------------------------------------------------------------------------------
--	FILE:	 GiantEarth.Lua
--  Convertion of Civ IV Genghis Kai's GEM (using Hornigas version for Civ V - BNW)
--  Imported to Civ VI by Gedemon (2016)
------------------------------------------------------------------------------

include "MapEnums"
include "MapUtilities"
include "MountainsCliffs"
include "RiversLakes"
include "FeatureGenerator"
include "TerrainGenerator"
include "NaturalWonderGenerator"
include "ResourceGenerator"
include "AssignStartingPlots"

local mapName = MapConfiguration.GetValue("MapName")
print("Loading "..tostring(mapName).." script")

local g_iW = 180
local g_iH = 94
local g_iFlags = {}
local g_continentsFrac = nil

------------------------------------------------------------------------------
-- The application side will call GetMapScriptInfo directly to request
-- information about the map script.
-------------------------------------------------------------------------------
function GetMapInitData(worldSize)
	return {
		Width = g_iW,
		Height = g_iH,
		WrapX = true,
		WrapY = false,
	};      
end


-------------------------------------------------------------------------------
function GenerateMap()
	print("Calling Map Generator");
	-- Everything has been moved to the modded AssignStartingPlots in the "override" folder, search for "YnAMP" string in that file
	GenerateImportedMap(GetMap(), GetCiv6DataToConvert(), GetNaturalWonders(), g_iW, g_iH)
	
	-- Handle Nile delta flow direction (North)
	for x = 29, 32 do
		for y = 46, 50 do
			local plot = Map.GetPlot(x,y)
			if plot then
				MakeRiverFlowToNorth(plot)			
			end
		end
	end
	
	-- Handle source of the Nile flow direction	
	for x = 31, 32 do
		for y = 29, 31 do
			local plot = Map.GetPlot(x,y)
			if plot then
				MakeRiverFlowToNorth(plot)			
			end
		end
	end
end

function GetNaturalWonders()
	local NaturalWonders = {}
	
	NaturalWonders[GameInfo.Features["FEATURE_BARRIER_REEF"].Index] 	 = { X = 101, Y = 23}
	NaturalWonders[GameInfo.Features["FEATURE_CLIFFS_DOVER"].Index] 	 = { X = 11, Y = 71}
	NaturalWonders[GameInfo.Features["FEATURE_CRATER_LAKE"].Index] 		 = { X = 132, Y = 65}
	NaturalWonders[GameInfo.Features["FEATURE_DEAD_SEA"].Index] 		 = { X = 37, Y = 50}
	NaturalWonders[GameInfo.Features["FEATURE_EVEREST"].Index] 			 = { X = 64, Y = 54}
	NaturalWonders[GameInfo.Features["FEATURE_GALAPAGOS"].Index] 		 = { X = 144, Y = 35}
	NaturalWonders[GameInfo.Features["FEATURE_KILIMANJARO"].Index] 		 = { X = 32, Y = 27}
	NaturalWonders[GameInfo.Features["FEATURE_PANTANAL"].Index] 		 = { X = 159, Y = 27}
	NaturalWonders[GameInfo.Features["FEATURE_PIOPIOTAHI"].Index] 		 = { X = 107, Y = 3}
	NaturalWonders[GameInfo.Features["FEATURE_TORRES_DEL_PAINE"].Index]  = { X = 154, Y = 7}
	NaturalWonders[GameInfo.Features["FEATURE_TSINGY"].Index] 			 = { X = 36, Y = 18}
	NaturalWonders[GameInfo.Features["FEATURE_YOSEMITE"].Index] 		 = { X = 132, Y = 62}
	
	return NaturalWonders
end

function GetCiv6DataToConvert()
	-- Map data was exported from Civ6 WB, cliffs are included in MapToConvert
	return {}
end

function GetMap()

	local MapToConvert = {}
	for i = 0, g_iW - 1, 1 do
		MapToConvert[i] = {}
	end
	
	-- Map Data (from Civ6 WB)
	-- MapToConvert[x][y] = {civ6TerrainType, civ6FeatureTypes, civ6ContinentType, {{IsNEOfRiver, flow}, {IsWOfRiver, flow}, {IsNWOfRiver, flow}}, {Civ6ResourceType, num}, {IsNEOfCliff, IsWOfCliff, IsNWOfCliff} }

 MapToConvert[0][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][0]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][0]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][0]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][0]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][0]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][0]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][0]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][0]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][0]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][0]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][0]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[55][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][1]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][1]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[106][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][1]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][1]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[156][1]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[157][1]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[158][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][1]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][1]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][1]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][1]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][1]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][2]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][2]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][2]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][2]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][2]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[11][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[12][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[56][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[57][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][2]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][2]={9,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[109][2]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[110][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][2]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][2]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[156][2]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[157][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[158][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[159][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][2]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][2]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][2]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][2]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][3]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][3]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][3]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][3]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[110][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][3]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[154][3]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{1,0,0}}
 MapToConvert[155][3]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[156][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][3]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][3]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][4]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][4]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[100][4]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[101][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][4]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][4]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][4]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[112][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][4]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[155][4]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][4]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[157][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[161][4]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[162][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][4]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][4]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][5]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][5]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[100][5]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[109][5]={4,2,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[110][5]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,1,1}}
 MapToConvert[111][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,1}}
 MapToConvert[154][5]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][5]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[156][5]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][5]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,1}}
 MapToConvert[162][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][5]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][5]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[24][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[26][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][6]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[101][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[110][6]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][6]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][6]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][6]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[155][6]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][6]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[157][6]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,1,1}}
 MapToConvert[158][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][6]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][6]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[23][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[24][7]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[25][7]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][7]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][7]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][7]={16,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][7]={0,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,1}}
 MapToConvert[100][7]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][7]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[102][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[108][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][7]={1,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][7]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[112][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[154][7]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][7]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][7]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[158][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[159][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][7]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][7]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][8]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[26][8]={0,3,0,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[27][8]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[28][8]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[29][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[95][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][8]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][8]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[99][8]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][8]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][8]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][8]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[103][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[112][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][8]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[154][8]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[155][8]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][8]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[157][8]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[158][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][8]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][8]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][9]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][9]={0,3,0,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[26][9]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][9]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[28][9]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][9]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][9]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][9]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[88][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][9]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][9]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][9]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[100][9]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][9]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[102][9]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[104][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[111][9]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[112][9]={1,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][9]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[153][9]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{1,0,0}}
 MapToConvert[154][9]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][9]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][9]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][9]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,1}}
 MapToConvert[158][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][9]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][9]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[23][10]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[24][10]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[25][10]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][10]={0,3,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[27][10]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][10]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[29][10]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[32][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][10]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][10]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[89][10]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[92][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[95][10]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][10]={4,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[98][10]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][10]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][10]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][10]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][10]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][10]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[104][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][10]={0,-1,5,{{0,-1},{1,0},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[113][10]={1,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][10]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,1,1}}
 MapToConvert[115][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][10]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][10]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[156][10]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][10]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[158][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][10]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][10]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][11]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[23][11]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][11]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[25][11]={7,-1,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[26][11]={6,0,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[27][11]={5,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[28][11]={5,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[29][11]={1,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[30][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][11]={1,3,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[87][11]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][11]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][11]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[90][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][11]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][11]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{1,0,0}}
 MapToConvert[95][11]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][11]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][11]={3,-1,5,{{0,-1},{0,-1},{1,4}},{1,1},{0,0,0}}
 MapToConvert[98][11]={3,-1,5,{{1,5},{1,3},{1,4}},{13,1},{0,0,0}}
 MapToConvert[99][11]={0,-1,5,{{1,5},{0,-1},{1,4}},{9,1},{0,0,0}}
 MapToConvert[100][11]={1,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[101][11]={2,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[102][11]={1,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][11]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,1}}
 MapToConvert[104][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[111][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][11]={0,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][11]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[153][11]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[154][11]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][11]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][11]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][11]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][11]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[159][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[162][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][11]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][11]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][12]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][12]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][12]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][12]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[26][12]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][12]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][12]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[29][12]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][12]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[31][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[85][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[86][12]={0,3,5,{{0,-1},{0,-1},{1,4}},{4,1},{1,0,0}}
 MapToConvert[87][12]={4,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][12]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][12]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[97][12]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][12]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][12]={7,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[100][12]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][12]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][12]={1,3,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[103][12]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][12]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[105][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[106][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][12]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,1,0}}
 MapToConvert[113][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[114][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[116][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][12]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][12]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][12]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[157][12]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][12]={3,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[159][12]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][12]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[161][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][12]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][12]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[20][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[22][13]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][13]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[24][13]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][13]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][13]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][13]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][13]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[29][13]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][13]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[31][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][13]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[86][13]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][13]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][13]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[91][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][13]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[97][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][13]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][13]={3,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[100][13]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][13]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][13]={1,3,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[103][13]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[104][13]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[111][13]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[113][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[153][13]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[154][13]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][13]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][13]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[157][13]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][13]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][13]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[160][13]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[161][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][13]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][13]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][14]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[23][14]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][14]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][14]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][14]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][14]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[28][14]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][14]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[30][14]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][14]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][14]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][14]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[37][14]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{8,1},{1,0,1}}
 MapToConvert[38][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][14]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[86][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][14]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][14]={6,4,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[99][14]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][14]={6,0,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[101][14]={3,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[102][14]={0,3,5,{{1,5},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[103][14]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][14]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[107][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[154][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{1,0,0}}
 MapToConvert[155][14]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][14]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][14]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][14]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][14]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[160][14]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][14]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[162][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][14]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][14]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][15]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][15]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[23][15]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][15]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[25][15]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][15]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][15]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][15]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][15]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][15]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[31][15]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[35][15]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[36][15]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][15]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[49][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[84][15]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][15]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[87][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][15]={6,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][15]={6,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][15]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][15]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][15]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][15]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][15]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{10,1},{0,1,0}}
 MapToConvert[105][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[135][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][15]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][15]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[156][15]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][15]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][15]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][15]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][15]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][15]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[162][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][15]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][15]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[20][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][16]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][16]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][16]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[24][16]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][16]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][16]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][16]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[28][16]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][16]={3,3,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[30][16]={3,-1,0,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][16]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{44,1},{0,1,0}}
 MapToConvert[32][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[33][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][16]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[37][16]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][16]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[40][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][16]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[48][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][16]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][16]={8,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][16]={7,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[99][16]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[100][16]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][16]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[102][16]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][16]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[104][16]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,1,0}}
 MapToConvert[105][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[155][16]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][16]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[157][16]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][16]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][16]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][16]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[161][16]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][16]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[163][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][16]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][16]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[20][17]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][17]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][17]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][17]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][17]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][17]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][17]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][17]={4,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][17]={4,3,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][17]={3,3,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[30][17]={3,-1,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][17]={3,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[34][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][17]={3,2,0,{{1,5},{0,-1},{1,4}},{27,1},{0,0,0}}
 MapToConvert[37][17]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][17]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,1,1}}
 MapToConvert[39][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][17]={0,3,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[50][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][17]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[94][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][17]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][17]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][17]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[103][17]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[105][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[106][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[134][17]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[135][17]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[136][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][17]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][17]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][17]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][17]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][17]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][17]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][17]={0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][17]={0,3,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][17]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[165][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][17]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][17]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][18]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{1,0,0}}
 MapToConvert[21][18]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][18]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][18]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[24][18]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][18]={3,3,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[26][18]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[27][18]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][18]={3,3,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][18]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][18]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][18]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[32][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][18]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][18]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][18]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][18]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,1}}
 MapToConvert[40][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[85][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][18]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[92][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][18]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][18]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][18]={4,3,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[102][18]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][18]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[135][18]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[136][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[137][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][18]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][18]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[157][18]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][18]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[159][18]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[160][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][18]={0,-1,2,{{0,-1},{1,0},{1,1}},{31,1},{0,0,0}}
 MapToConvert[162][18]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][18]={0,-1,2,{{1,2},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[164][18]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[165][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][18]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][18]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[20][19]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][19]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[22][19]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][19]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][19]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][19]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][19]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][19]={3,-1,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][19]={3,3,0,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[29][19]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][19]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[31][19]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[36][19]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[37][19]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][19]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[41][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[85][19]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][19]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[87][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][19]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][19]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][19]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][19]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][19]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][19]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][19]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][19]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][19]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[158][19]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][19]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,1}}
 MapToConvert[160][19]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][19]={0,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[162][19]={0,3,2,{{1,2},{1,3},{1,4}},{40,1},{0,0,0}}
 MapToConvert[163][19]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][19]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][19]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,1,0}}
 MapToConvert[166][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[168][19]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][19]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][20]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][20]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][20]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][20]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][20]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[25][20]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][20]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[27][20]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[28][20]={3,3,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[29][20]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][20]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][20]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][20]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][20]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[34][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[37][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][20]={4,3,0,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[39][20]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[87][20]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][20]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[89][20]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][20]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][20]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][20]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][20]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][20]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][20]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][20]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][20]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[98][20]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][20]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][20]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][20]={3,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[102][20]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[104][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[106][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][20]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,1,1}}
 MapToConvert[108][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[155][20]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][20]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[157][20]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][20]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][20]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][20]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][20]={0,-1,2,{{0,-1},{1,3},{1,4}},{1,1},{0,0,0}}
 MapToConvert[162][20]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][20]={4,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[164][20]={0,3,2,{{1,5},{1,3},{1,4}},{10,1},{0,0,0}}
 MapToConvert[165][20]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][20]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[167][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][20]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][20]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[20][21]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[21][21]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][21]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][21]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][21]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][21]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][21]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][21]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][21]={3,3,0,{{0,-1},{0,-1},{1,4}},{15,1},{0,0,0}}
 MapToConvert[29][21]={3,3,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[30][21]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[31][21]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][21]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][21]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][21]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[39][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[86][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][21]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][21]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[90][21]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][21]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][21]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][21]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][21]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][21]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][21]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][21]={3,2,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][21]={4,2,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[99][21]={3,2,5,{{1,5},{0,-1},{1,4}},{0,1},{0,0,0}}
 MapToConvert[100][21]={3,2,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[102][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[103][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][21]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[109][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][21]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][21]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][21]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[157][21]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][21]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][21]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][21]={1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][21]={0,-1,2,{{1,2},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[162][21]={0,-1,2,{{1,5},{1,3},{1,4}},{9,1},{0,0,0}}
 MapToConvert[163][21]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[164][21]={0,3,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[165][21]={2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][21]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[167][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[168][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][21]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][21]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][22]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][22]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][22]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][22]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[24][22]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][22]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][22]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][22]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][22]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][22]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][22]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][22]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][22]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][22]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[38][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[39][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[40][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[89][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[90][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][22]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][22]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][22]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[94][22]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[95][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[98][22]={3,2,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][22]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][22]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[103][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][22]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[121][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][22]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[157][22]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][22]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][22]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][22]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][22]={3,2,2,{{0,-1},{1,3},{1,4}},{28,1},{0,0,0}}
 MapToConvert[162][22]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][22]={0,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[164][22]={0,3,2,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[165][22]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][22]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][22]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][22]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[169][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][22]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][22]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[20][23]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][23]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][23]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[23][23]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[24][23]={3,3,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[25][23]={0,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][23]={1,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][23]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][23]={3,3,0,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[29][23]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][23]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][23]={3,3,0,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[32][23]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][23]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][23]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[79][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[91][23]={3,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[92][23]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][23]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][23]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[95][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[97][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][23]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[99][23]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[100][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[101][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][23]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[118][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[120][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[122][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][23]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[124][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[153][23]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[154][23]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][23]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[156][23]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][23]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][23]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][23]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][23]={3,2,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][23]={3,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][23]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][23]={4,2,2,{{0,-1},{1,3},{1,4}},{43,1},{0,0,0}}
 MapToConvert[164][23]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][23]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][23]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[167][23]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[168][23]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][23]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][23]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][24]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[21][24]={3,2,0,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[22][24]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][24]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[24][24]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][24]={1,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][24]={1,2,0,{{0,-1},{1,0},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[27][24]={0,2,0,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][24]={3,3,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][24]={4,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][24]={4,3,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[31][24]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][24]={4,3,0,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[34][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[35][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][24]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][24]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[85][24]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[86][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[87][24]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[88][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][24]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][24]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[94][24]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][24]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[96][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[98][24]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[99][24]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[100][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[109][24]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][24]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[113][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[125][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][24]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][24]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][24]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][24]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[157][24]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][24]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][24]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[160][24]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][24]={3,2,2,{{0,-1},{1,3},{1,4}},{0,1},{0,0,0}}
 MapToConvert[162][24]={3,2,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[163][24]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][24]={0,5,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[165][24]={3,-1,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[166][24]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][24]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][24]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[169][24]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{42,1},{0,1,0}}
 MapToConvert[170][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][24]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][24]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][25]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][25]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[21][25]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][25]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][25]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][25]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[25][25]={3,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][25]={3,-1,0,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][25]={3,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][25]={3,2,0,{{0,-1},{1,0},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[29][25]={3,2,0,{{1,5},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[30][25]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[32][25]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[33][25]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[34][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][25]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[79][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[80][25]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[81][25]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][25]={4,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[83][25]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[84][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[85][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][25]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][25]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,1,0}}
 MapToConvert[90][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[92][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[93][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[94][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[96][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][25]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][25]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][25]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{1,0,0}}
 MapToConvert[109][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[112][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][25]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{1,0,1}}
 MapToConvert[114][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[116][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[151][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[152][25]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[153][25]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][25]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][25]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][25]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][25]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][25]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][25]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][25]={3,2,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][25]={3,2,2,{{1,2},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[162][25]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][25]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][25]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][25]={3,3,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[166][25]={3,-1,2,{{1,5},{1,3},{1,4}},{31,1},{0,0,0}}
 MapToConvert[167][25]={1,3,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[168][25]={5,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{1,0,0}}
 MapToConvert[170][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][25]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][25]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[19][26]={3,2,0,{{0,-1},{0,-1},{0,-1}},{11,1},{1,0,0}}
 MapToConvert[20][26]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][26]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][26]={3,2,0,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[23][26]={4,2,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[24][26]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[25][26]={3,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][26]={3,2,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[27][26]={3,2,0,{{1,5},{1,0},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[28][26]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][26]={3,2,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[30][26]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][26]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][26]={4,2,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[33][26]={4,2,0,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[34][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][26]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[48][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[78][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][26]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][26]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[82][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[83][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[86][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[91][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[100][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[102][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][26]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][26]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[154][26]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][26]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][26]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][26]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][26]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[159][26]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][26]={3,2,2,{{0,-1},{1,3},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[161][26]={3,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][26]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][26]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[164][26]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][26]={4,3,2,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[166][26]={4,3,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][26]={4,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[168][26]={1,3,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[169][26]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[170][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][26]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][26]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][27]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][27]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[20][27]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][27]={3,2,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[22][27]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][27]={4,2,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[24][27]={3,2,0,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[25][27]={3,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][27]={0,5,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][27]={3,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][27]={0,5,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][27]={3,2,0,{{1,5},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[30][27]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][27]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][27]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][27]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{42,1},{0,1,0}}
 MapToConvert[34][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[35][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[47][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[48][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][27]={0,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[75][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][27]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[78][27]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[79][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[81][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[86][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[88][27]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[89][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][27]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[92][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][27]={3,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,1}}
 MapToConvert[117][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[128][27]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[129][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[131][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][27]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][27]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][27]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][27]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[155][27]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][27]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][27]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][27]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][27]={3,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][27]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][27]={4,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][27]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][27]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][27]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][27]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][27]={3,-1,2,{{0,-1},{1,0},{1,1}},{9,1},{0,0,0}}
 MapToConvert[167][27]={4,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][27]={4,3,2,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[169][27]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[170][27]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][27]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][27]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][28]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[20][28]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[21][28]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][28]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][28]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][28]={3,2,0,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[25][28]={3,2,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[26][28]={3,2,0,{{1,5},{1,3},{1,4}},{15,1},{0,0,0}}
 MapToConvert[27][28]={3,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][28]={3,2,0,{{0,-1},{1,0},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[29][28]={3,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][28]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[31][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][28]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][28]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][28]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[35][28]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[36][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][28]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[77][28]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{1,0,0}}
 MapToConvert[78][28]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][28]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[83][28]={3,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[84][28]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,1}}
 MapToConvert[85][28]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][28]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][28]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[93][28]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[96][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][28]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][28]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[100][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][28]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,1,1}}
 MapToConvert[103][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[129][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{1,0,0}}
 MapToConvert[130][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[151][28]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[152][28]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[153][28]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][28]={5,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][28]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][28]={4,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][28]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][28]={3,2,2,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[159][28]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][28]={3,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[161][28]={3,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[162][28]={4,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][28]={4,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][28]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[165][28]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[166][28]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][28]={4,3,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[168][28]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][28]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[170][28]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][28]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][28]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][28]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[19][29]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][29]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][29]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[22][29]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][29]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[24][29]={3,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][29]={0,5,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[26][29]={3,2,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[27][29]={3,2,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][29]={3,2,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][29]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[30][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[31][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][29]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][29]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][29]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][29]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[36][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[38][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[72][29]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][29]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][29]={3,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[77][29]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][29]={0,5,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[80][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][29]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][29]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[83][29]={4,2,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[84][29]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[85][29]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[86][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][29]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][29]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][29]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][29]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[99][29]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][29]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][29]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[113][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][29]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[151][29]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][29]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][29]={5,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][29]={3,2,2,{{1,5},{1,0},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[155][29]={3,2,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[156][29]={3,2,2,{{1,5},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[157][29]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][29]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][29]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][29]={4,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][29]={3,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][29]={4,2,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[163][29]={1,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[164][29]={4,-1,2,{{0,-1},{1,0},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[165][29]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[166][29]={3,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[167][29]={3,3,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[168][29]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][29]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][29]={4,3,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[171][29]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[172][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][29]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][29]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][30]={3,2,0,{{0,-1},{0,-1},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[20][30]={3,2,0,{{1,5},{0,-1},{1,4}},{11,1},{0,0,0}}
 MapToConvert[21][30]={3,2,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[22][30]={3,2,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[23][30]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][30]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][30]={3,2,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[26][30]={3,2,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[27][30]={3,2,0,{{1,5},{1,3},{1,4}},{28,1},{0,0,0}}
 MapToConvert[28][30]={3,2,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[29][30]={1,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[30][30]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][30]={1,-1,0,{{0,-1},{1,3},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[32][30]={2,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[33][30]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][30]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][30]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[40][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][30]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[60][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[63][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[73][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][30]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][30]={3,2,5,{{0,-1},{1,0},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[76][30]={3,2,5,{{1,5},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[77][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][30]={0,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[82][30]={3,2,5,{{1,5},{1,3},{1,4}},{27,1},{0,0,0}}
 MapToConvert[83][30]={3,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[84][30]={4,2,5,{{0,-1},{1,3},{1,4}},{26,1},{0,0,0}}
 MapToConvert[85][30]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[86][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][30]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,1,0}}
 MapToConvert[89][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[90][30]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[91][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[95][30]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][30]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][30]={4,2,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[98][30]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][30]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][30]={3,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[101][30]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[114][30]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,1,0}}
 MapToConvert[115][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][30]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][30]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[152][30]={1,3,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][30]={1,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][30]={3,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][30]={3,2,2,{{0,-1},{1,0},{1,1}},{4,1},{0,0,0}}
 MapToConvert[156][30]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][30]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][30]={4,2,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[159][30]={3,2,2,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[160][30]={0,5,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[161][30]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[162][30]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][30]={3,2,2,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[164][30]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[165][30]={3,2,2,{{0,-1},{1,0},{1,1}},{28,1},{0,0,0}}
 MapToConvert[166][30]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][30]={3,3,2,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[168][30]={3,3,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[169][30]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[170][30]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][30]={3,2,2,{{0,-1},{0,-1},{0,-1}},{10,1},{0,1,0}}
 MapToConvert[172][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[173][30]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][30]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[9][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[13][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][31]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][31]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[21][31]={3,2,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[22][31]={4,2,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[23][31]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][31]={3,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][31]={3,2,0,{{1,5},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[26][31]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][31]={3,2,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][31]={3,2,0,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[29][31]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][31]={4,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][31]={2,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][31]={0,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][31]={5,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[35][31]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][31]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][31]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[38][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][31]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[72][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[73][31]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[74][31]={3,2,5,{{0,-1},{0,-1},{1,1}},{4,1},{0,0,0}}
 MapToConvert[75][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[76][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[79][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[81][31]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][31]={0,-1,5,{{0,-1},{0,-1},{1,4}},{9,1},{0,0,0}}
 MapToConvert[83][31]={4,2,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[84][31]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][31]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[86][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][31]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[89][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][31]={3,2,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[91][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][31]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][31]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[95][31]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[96][31]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][31]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][31]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[99][31]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[100][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][31]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][31]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][31]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][31]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][31]={1,3,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][31]={1,3,2,{{1,5},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[153][31]={3,2,2,{{0,-1},{1,0},{1,1}},{15,1},{0,0,0}}
 MapToConvert[154][31]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][31]={3,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][31]={3,2,2,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[157][31]={4,2,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[158][31]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[159][31]={3,2,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[160][31]={3,2,2,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][31]={3,2,2,{{1,5},{1,0},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[162][31]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][31]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][31]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[165][31]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[166][31]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][31]={3,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[168][31]={3,-1,2,{{1,2},{0,-1},{1,1}},{9,1},{0,0,0}}
 MapToConvert[169][31]={3,-1,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[170][31]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][31]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][31]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][32]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[9][32]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[10][32]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[19][32]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][32]={3,2,0,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[21][32]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][32]={4,2,0,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[23][32]={4,2,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[24][32]={4,2,0,{{1,5},{0,-1},{1,4}},{41,1},{0,0,0}}
 MapToConvert[25][32]={0,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][32]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[27][32]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][32]={3,2,0,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[29][32]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][32]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[31][32]={1,-1,0,{{0,-1},{1,3},{1,1}},{14,1},{0,0,0}}
 MapToConvert[32][32]={1,2,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][32]={3,3,0,{{1,5},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[34][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[35][32]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][32]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[37][32]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][32]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][32]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[40][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[42][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][32]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][32]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[65][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][32]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[74][32]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][32]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[77][32]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[78][32]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[79][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[82][32]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[83][32]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[84][32]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][32]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][32]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[87][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][32]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][32]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[90][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][32]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[94][32]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][32]={4,2,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[97][32]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[98][32]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[99][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[100][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][32]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[105][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[150][32]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[151][32]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][32]={0,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[153][32]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[154][32]={3,2,2,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[155][32]={3,2,2,{{1,2},{1,0},{1,1}},{11,1},{0,0,0}}
 MapToConvert[156][32]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][32]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][32]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][32]={3,2,2,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[160][32]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[161][32]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[162][32]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[163][32]={0,5,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[164][32]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][32]={3,2,2,{{1,5},{1,0},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[166][32]={3,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][32]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[168][32]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[169][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][32]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][32]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][33]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[8][33]={3,2,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[9][33]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][33]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][33]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,1}}
 MapToConvert[12][33]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[13][33]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][33]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][33]={3,2,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][33]={3,2,0,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[19][33]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][33]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[21][33]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][33]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][33]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][33]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][33]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][33]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][33]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[28][33]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][33]={4,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][33]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][33]={3,3,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[32][33]={3,3,0,{{0,-1},{1,0},{1,1}},{4,1},{0,0,0}}
 MapToConvert[33][33]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][33]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][33]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][33]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][33]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[38][33]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][33]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[40][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[60][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][33]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[63][33]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][33]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[73][33]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][33]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[76][33]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[77][33]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[78][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[82][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[83][33]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][33]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][33]={4,2,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[86][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][33]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[95][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[97][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[99][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[101][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[113][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][33]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][33]={0,-1,2,{{0,-1},{1,3},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[152][33]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[153][33]={3,2,2,{{1,2},{0,-1},{1,1}},{28,1},{0,0,0}}
 MapToConvert[154][33]={3,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][33]={0,5,2,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[156][33]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[157][33]={3,2,2,{{1,2},{0,-1},{1,1}},{0,1},{0,0,0}}
 MapToConvert[158][33]={0,5,2,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[159][33]={0,5,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[160][33]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[161][33]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[162][33]={3,2,2,{{0,-1},{1,0},{1,1}},{15,1},{0,0,0}}
 MapToConvert[163][33]={3,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][33]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[165][33]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[166][33]={3,2,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[167][33]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[168][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[169][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][33]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][33]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][34]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][34]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[9][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[11][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][34]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][34]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[15][34]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[17][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{1,0,0}}
 MapToConvert[18][34]={3,2,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[19][34]={0,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][34]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[24][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][34]={3,2,0,{{0,-1},{1,0},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[26][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][34]={3,2,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[28][34]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][34]={3,3,0,{{0,-1},{1,0},{1,1}},{19,1},{0,0,0}}
 MapToConvert[30][34]={4,3,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][34]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][34]={3,-1,0,{{0,-1},{1,0},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[33][34]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][34]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][34]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][34]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[37][34]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][34]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][34]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[40][34]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[41][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][34]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[63][34]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[64][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][34]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][34]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[75][34]={3,2,5,{{0,-1},{0,-1},{0,-1}},{25,1},{1,0,0}}
 MapToConvert[76][34]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[77][34]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[84][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[85][34]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][34]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[96][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[100][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][34]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][34]={2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][34]={3,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][34]={3,2,2,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[154][34]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[155][34]={3,2,2,{{1,2},{0,-1},{1,1}},{15,1},{0,0,0}}
 MapToConvert[156][34]={3,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][34]={3,2,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][34]={3,2,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[159][34]={3,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][34]={3,2,2,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[161][34]={3,2,2,{{1,2},{0,-1},{1,1}},{28,1},{0,0,0}}
 MapToConvert[162][34]={3,2,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[163][34]={0,5,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[164][34]={3,2,2,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[165][34]={3,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[166][34]={3,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[167][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[168][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][34]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][34]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[6][35]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{7,1},{1,0,0}}
 MapToConvert[7][35]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][35]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][35]={3,2,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[10][35]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][35]={3,2,0,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[12][35]={3,2,0,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[13][35]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][35]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][35]={4,2,0,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[16][35]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][35]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][35]={3,2,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[19][35]={3,2,0,{{1,5},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[20][35]={4,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][35]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[22][35]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][35]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][35]={3,3,0,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[29][35]={3,3,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[30][35]={3,3,0,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][35]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][35]={4,3,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][35]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][35]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][35]={4,-1,0,{{1,5},{1,3},{1,4}},{43,1},{0,0,0}}
 MapToConvert[36][35]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][35]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][35]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[39][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[40][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[41][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][35]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[60][35]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{1,0,0}}
 MapToConvert[61][35]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[64][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][35]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[74][35]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][35]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,1,0}}
 MapToConvert[76][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[80][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[84][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][35]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[86][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][35]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][35]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[91][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][35]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[150][35]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][35]={3,2,2,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[152][35]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][35]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][35]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][35]={3,2,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][35]={3,2,2,{{1,2},{0,-1},{1,1}},{28,1},{0,0,0}}
 MapToConvert[157][35]={2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][35]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][35]={3,2,2,{{0,-1},{1,3},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[160][35]={3,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][35]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][35]={3,2,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[163][35]={3,2,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[164][35]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[167][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][35]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][35]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[6][36]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[7][36]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][36]={4,3,0,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[9][36]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][36]={3,2,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[11][36]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][36]={3,2,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][36]={3,2,0,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[14][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][36]={3,2,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[16][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][36]={3,2,0,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[18][36]={3,2,0,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[19][36]={4,3,0,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[20][36]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][36]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][36]={4,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[24][36]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][36]={3,3,0,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][36]={3,3,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[28][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[31][36]={3,3,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][36]={3,3,0,{{1,2},{1,0},{1,1}},{15,1},{0,0,0}}
 MapToConvert[33][36]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][36]={3,-1,0,{{0,-1},{1,0},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[35][36]={5,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][36]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[38][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[40][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[42][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][36]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][36]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][36]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,1}}
 MapToConvert[63][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[65][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[73][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][36]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[75][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[77][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[86][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[87][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][36]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][36]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][36]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[93][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][36]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[109][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[112][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[151][36]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][36]={4,2,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[153][36]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][36]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][36]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][36]={3,2,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][36]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][36]={2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][36]={3,2,2,{{1,2},{0,-1},{1,1}},{11,1},{0,0,0}}
 MapToConvert[160][36]={0,5,2,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[161][36]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][36]={4,2,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[163][36]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][36]={0,5,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[165][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][36]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][36]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][37]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[6][37]={4,3,0,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[7][37]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][37]={4,3,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[9][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[10][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[12][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][37]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][37]={3,3,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][37]={3,3,0,{{1,2},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[20][37]={4,3,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[21][37]={4,3,0,{{1,5},{0,-1},{1,4}},{43,1},{0,0,0}}
 MapToConvert[22][37]={3,3,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][37]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][37]={3,-1,0,{{1,5},{0,-1},{1,4}},{7,1},{0,0,0}}
 MapToConvert[25][37]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][37]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[27][37]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][37]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[29][37]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][37]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[31][37]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][37]={3,3,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[33][37]={3,3,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][37]={4,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][37]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[36][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[37][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][37]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,1}}
 MapToConvert[39][37]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[40][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[58][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][37]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][37]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][37]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[62][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[63][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[69][37]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{1,0,0}}
 MapToConvert[70][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[73][37]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{1,0,0}}
 MapToConvert[74][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][37]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{1,0,1}}
 MapToConvert[78][37]={0,5,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][37]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[87][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[90][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[91][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[105][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[108][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][37]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[149][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][37]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[151][37]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][37]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][37]={4,2,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[154][37]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][37]={3,2,2,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[156][37]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][37]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][37]={2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][37]={4,2,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[160][37]={3,2,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[161][37]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][37]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][37]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][37]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[165][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][37]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][37]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][38]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][38]={3,3,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[7][38]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][38]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][38]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][38]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][38]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][38]={4,3,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[13][38]={3,3,0,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[14][38]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][38]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][38]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][38]={3,3,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][38]={3,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[19][38]={3,-1,0,{{1,2},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[20][38]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[21][38]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][38]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][38]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][38]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[26][38]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][38]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][38]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][38]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][38]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][38]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[32][38]={3,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][38]={3,3,0,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][38]={3,-1,0,{{1,5},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[35][38]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[37][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][38]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][38]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][38]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][38]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,1,1}}
 MapToConvert[42][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[45][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[59][38]={1,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[60][38]={1,-1,5,{{1,5},{0,-1},{1,4}},{8,1},{0,0,0}}
 MapToConvert[61][38]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][38]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[63][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][38]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[71][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][38]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[75][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[77][38]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][38]={0,5,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][38]={0,5,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[82][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][38]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[90][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][38]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,1,0}}
 MapToConvert[92][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[94][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][38]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[112][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][38]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][38]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][38]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][38]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][38]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][38]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][38]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][38]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[160][38]={2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[161][38]={2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][38]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][38]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][38]={3,2,2,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[165][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[167][38]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][38]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][39]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][39]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][39]={3,-1,0,{{0,-1},{1,0},{1,1}},{19,1},{0,0,0}}
 MapToConvert[7][39]={4,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][39]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[9][39]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][39]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[11][39]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][39]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][39]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][39]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][39]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][39]={3,-1,0,{{1,2},{0,-1},{1,1}},{13,1},{0,0,0}}
 MapToConvert[17][39]={3,-1,0,{{1,2},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[18][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[22][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[24][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][39]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][39]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[28][39]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[30][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[32][39]={3,-1,0,{{0,-1},{1,0},{1,1}},{9,1},{0,0,0}}
 MapToConvert[33][39]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[35][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[37][39]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{21,1},{1,0,0}}
 MapToConvert[38][39]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][39]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[40][39]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][39]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[43][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][39]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][39]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][39]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][39]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[62][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][39]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[73][39]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[74][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][39]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[76][39]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[77][39]={3,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][39]={3,2,5,{{1,2},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[79][39]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[80][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[87][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][39]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[90][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[92][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][39]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[106][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[112][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[120][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[149][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][39]={3,2,2,{{0,-1},{0,-1},{0,-1}},{11,1},{1,0,0}}
 MapToConvert[152][39]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][39]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[154][39]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][39]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[156][39]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[157][39]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][39]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][39]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][39]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][39]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[162][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[164][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][39]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][39]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][40]={1,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[1][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[5][40]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[6][40]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][40]={6,0,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[8][40]={7,-1,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[9][40]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][40]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][40]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][40]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][40]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][40]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[15][40]={3,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][40]={6,0,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[21][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[26][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][40]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[28][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][40]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][40]={3,-1,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][40]={3,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[36][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][40]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][40]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[43][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][40]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[45][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][40]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][40]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[60][40]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][40]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[62][40]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[71][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[74][40]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][40]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][40]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][40]={3,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][40]={3,2,5,{{1,2},{1,3},{1,4}},{25,1},{0,0,0}}
 MapToConvert[79][40]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][40]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,1}}
 MapToConvert[81][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][40]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[89][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[109][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[112][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][40]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][40]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][40]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][40]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][40]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][40]={3,3,2,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[156][40]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][40]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][40]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][40]={3,2,2,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[160][40]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][40]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[164][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][40]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][40]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][41]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][41]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][41]={6,-1,0,{{1,5},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[8][41]={7,-1,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[9][41]={6,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[10][41]={6,0,0,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][41]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][41]={6,-1,0,{{0,-1},{1,3},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[13][41]={6,0,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[14][41]={7,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[15][41]={6,-1,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][41]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][41]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][41]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][41]={6,0,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[32][41]={3,-1,0,{{0,-1},{1,0},{1,1}},{19,1},{0,0,0}}
 MapToConvert[33][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][41]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[37][41]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][41]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[40][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][41]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][41]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[46][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][41]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][41]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][41]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][41]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][41]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[63][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[70][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[71][41]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[72][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][41]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][41]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[75][41]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[76][41]={3,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[77][41]={3,2,5,{{1,2},{1,3},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[78][41]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][41]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][41]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[89][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[146][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[148][41]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][41]={1,2,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[150][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[151][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[152][41]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[153][41]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[155][41]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][41]={1,3,2,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[157][41]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][41]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[159][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[160][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[161][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[162][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][41]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][41]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][42]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][42]={6,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[7][42]={6,-1,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][42]={6,0,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[12][42]={6,0,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[13][42]={6,0,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][42]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[16][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][42]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][42]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][42]={6,0,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][42]={6,0,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[33][42]={6,0,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[36][42]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][42]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][42]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][42]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[45][42]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][42]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[47][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[55][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[58][42]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][42]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[60][42]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[61][42]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][42]={3,-1,5,{{0,-1},{1,3},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[63][42]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[64][42]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,1,0}}
 MapToConvert[65][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][42]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][42]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][42]={3,2,5,{{0,-1},{1,3},{1,4}},{27,1},{0,0,0}}
 MapToConvert[74][42]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][42]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][42]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][42]={3,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][42]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][42]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[80][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][42]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][42]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[89][42]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[90][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[102][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][42]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,1,0}}
 MapToConvert[111][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][42]={4,2,2,{{0,-1},{0,-1},{0,-1}},{44,1},{1,0,0}}
 MapToConvert[149][42]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[154][42]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[156][42]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[159][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[160][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][42]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][42]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[3][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][43]={6,-1,0,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[5][43]={6,4,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][43]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[24][43]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][43]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[26][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[30][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[31][43]={6,0,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][43]={6,0,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[33][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[36][43]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][43]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[38][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[39][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][43]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[43][43]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][43]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[45][43]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[47][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[57][43]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[58][43]={4,2,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[59][43]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][43]={3,2,5,{{0,-1},{1,3},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[61][43]={3,2,5,{{1,2},{0,-1},{1,1}},{27,1},{0,0,0}}
 MapToConvert[62][43]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][43]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][43]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[65][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[66][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[70][43]={4,2,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[71][43]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][43]={1,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][43]={2,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][43]={3,2,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[75][43]={3,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[76][43]={4,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][43]={3,2,5,{{1,2},{0,-1},{0,-1}},{28,1},{0,1,0}}
 MapToConvert[78][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[79][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[81][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[87][43]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][43]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][43]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,1,1}}
 MapToConvert[100][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[146][43]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[147][43]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[148][43]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,1,0}}
 MapToConvert[149][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[151][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[156][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][43]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][43]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][44]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[5][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[7][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[9][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[26][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[31][44]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][44]={6,0,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[33][44]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[38][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][44]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[42][44]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[44][44]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][44]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[46][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[55][44]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[56][44]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][44]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][44]={4,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[60][44]={4,2,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[61][44]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][44]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[63][44]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[64][44]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][44]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][44]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,1,1}}
 MapToConvert[67][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[71][44]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][44]={0,-1,5,{{0,-1},{1,3},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[73][44]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][44]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][44]={4,2,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][44]={4,2,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[77][44]={3,-1,5,{{1,2},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[78][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[88][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[140][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[145][44]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[146][44]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][44]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][44]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][44]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[150][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[157][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[161][44]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[162][44]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][44]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][45]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[2][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[3][45]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[5][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][45]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][45]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[16][45]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][45]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][45]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[19][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[29][45]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[30][45]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][45]={6,0,0,{{1,5},{0,-1},{1,4}},{19,1},{0,0,0}}
 MapToConvert[32][45]={6,0,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[35][45]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[36][45]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[37][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[38][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][45]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][45]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[42][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[43][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[44][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][45]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][45]={3,2,5,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[57][45]={3,2,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[58][45]={3,2,5,{{1,5},{1,3},{1,4}},{27,1},{0,0,0}}
 MapToConvert[59][45]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[60][45]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][45]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][45]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][45]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][45]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[65][45]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][45]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][45]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[70][45]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][45]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[72][45]={4,2,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[73][45]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][45]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][45]={4,2,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[76][45]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[77][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][45]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[81][45]={4,2,5,{{0,-1},{0,-1},{0,-1}},{43,1},{1,0,1}}
 MapToConvert[82][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[119][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[140][45]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][45]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][45]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[143][45]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][45]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][45]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][45]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[147][45]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][45]={3,2,2,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[149][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[161][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[162][45]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][45]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[4][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][46]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][46]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][46]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][46]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][46]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][46]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][46]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][46]={6,0,0,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][46]={6,0,0,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[35][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[36][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][46]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[41][46]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][46]={3,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][46]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[47][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{10,1},{1,0,0}}
 MapToConvert[48][46]={3,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[50][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[51][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[53][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][46]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][46]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[57][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[58][46]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][46]={3,2,5,{{0,-1},{0,-1},{1,4}},{27,1},{0,0,0}}
 MapToConvert[60][46]={3,2,5,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][46]={4,3,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[62][46]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[64][46]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][46]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][46]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[67][46]={3,2,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,1,1}}
 MapToConvert[68][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[70][46]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][46]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][46]={0,-1,5,{{0,-1},{1,3},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[73][46]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][46]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][46]={3,2,5,{{0,-1},{1,3},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[76][46]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][46]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[78][46]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[79][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][46]={3,2,5,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[82][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][46]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[90][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[123][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,1,0}}
 MapToConvert[139][46]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[140][46]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[141][46]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][46]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][46]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[144][46]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][46]={4,2,2,{{0,-1},{1,0},{1,1}},{8,1},{0,0,0}}
 MapToConvert[146][46]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[149][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{1,0,0}}
 MapToConvert[150][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][46]={3,2,2,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[153][46]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[154][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[155][46]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][46]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{28,1},{1,0,0}}
 MapToConvert[157][46]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][46]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[160][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][46]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][46]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][46]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[5][47]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[6][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][47]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[8][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[10][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[13][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][47]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[16][47]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[19][47]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[21][47]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][47]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[23][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[24][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[26][47]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][47]={6,4,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][47]={6,-1,0,{{0,-1},{1,0},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[30][47]={6,0,0,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[31][47]={6,0,0,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[32][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][47]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[34][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[36][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[38][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][47]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{45,1},{0,1,0}}
 MapToConvert[41][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[42][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[44][47]={3,3,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[45][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[46][47]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][47]={3,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[49][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[50][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,1}}
 MapToConvert[52][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[53][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][47]={6,0,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[55][47]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][47]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][47]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[59][47]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][47]={4,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][47]={4,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[62][47]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][47]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[64][47]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][47]={3,2,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[66][47]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,1}}
 MapToConvert[70][47]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][47]={0,-1,5,{{0,-1},{1,3},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[72][47]={4,2,5,{{1,2},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[73][47]={2,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][47]={4,2,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[75][47]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][47]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][47]={3,2,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[78][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][47]={0,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[81][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[86][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[118][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][47]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][47]={3,2,2,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[121][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][47]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[138][47]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[139][47]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][47]={4,2,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[141][47]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][47]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][47]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][47]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][47]={4,2,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][47]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[152][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][47]={4,2,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[155][47]={4,2,2,{{1,5},{0,-1},{1,4}},{8,1},{0,0,0}}
 MapToConvert[156][47]={1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][47]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][47]={4,2,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,1}}
 MapToConvert[160][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][47]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][47]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[4][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][48]={3,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[7][48]={3,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[8][48]={8,-1,0,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[9][48]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][48]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][48]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[18][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][48]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][48]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[21][48]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][48]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][48]={3,3,0,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[24][48]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][48]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][48]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[27][48]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][48]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[29][48]={4,-1,0,{{0,-1},{1,3},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[30][48]={6,0,0,{{1,2},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][48]={0,-1,0,{{1,5},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[32][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[33][48]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][48]={6,-1,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][48]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[36][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][48]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][48]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][48]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,1,0}}
 MapToConvert[43][48]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[44][48]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[46][48]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[47][48]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][48]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][48]={5,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][48]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][48]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][48]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[53][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[54][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[55][48]={6,0,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[56][48]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][48]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][48]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[59][48]={0,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[61][48]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[63][48]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][48]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][48]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[67][48]={0,5,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][48]={0,5,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][48]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][48]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][48]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][48]={2,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[73][48]={2,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][48]={1,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[76][48]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][48]={3,2,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[78][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][48]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[80][48]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][48]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[83][48]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[84][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][48]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{1,0,1}}
 MapToConvert[89][48]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[101][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][48]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,1,0}}
 MapToConvert[110][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[119][48]={4,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[120][48]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][48]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[136][48]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][48]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][48]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[139][48]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][48]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][48]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[142][48]={0,2,2,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[143][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[144][48]={0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][48]={0,5,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][48]={3,2,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[147][48]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{10,1},{0,1,1}}
 MapToConvert[148][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][48]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[154][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[156][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[158][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][48]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][48]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][49]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[6][49]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[7][49]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][49]={4,-1,0,{{1,2},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[9][49]={8,-1,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[10][49]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[11][49]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][49]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][49]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][49]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[15][49]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][49]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[17][49]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][49]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][49]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][49]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][49]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[22][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[23][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[25][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][49]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][49]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[28][49]={3,-1,0,{{0,-1},{1,0},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[29][49]={6,0,0,{{1,2},{1,0},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[30][49]={0,-1,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][49]={0,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][49]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][49]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][49]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][49]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[36][49]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[37][49]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][49]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][49]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][49]={6,0,0,{{0,-1},{1,3},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[41][49]={6,0,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][49]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][49]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][49]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[48][49]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][49]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][49]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[51][49]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][49]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[54][49]={6,0,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][49]={6,0,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[57][49]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][49]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[59][49]={0,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[60][49]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][49]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][49]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][49]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][49]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[65][49]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][49]={0,5,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][49]={0,5,5,{{1,2},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[68][49]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][49]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][49]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][49]={4,2,5,{{0,-1},{1,3},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[72][49]={4,2,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][49]={2,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[74][49]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][49]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][49]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[77][49]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][49]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[79][49]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][49]={3,2,5,{{0,-1},{0,-1},{0,-1}},{27,1},{0,0,0}}
 MapToConvert[81][49]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][49]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][49]={4,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[84][49]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][49]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][49]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[109][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[110][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][49]={4,2,2,{{1,5},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[120][49]={0,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[121][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[122][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[135][49]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[136][49]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[138][49]={4,2,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[139][49]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[140][49]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[143][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][49]={3,2,2,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[146][49]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][49]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][49]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][49]={3,2,2,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,0}}
 MapToConvert[155][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][49]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][49]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[3][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[7][50]={3,-1,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[8][50]={4,3,0,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[9][50]={4,-1,0,{{1,5},{0,-1},{1,4}},{7,1},{0,0,0}}
 MapToConvert[10][50]={4,-1,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][50]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][50]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][50]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][50]={8,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][50]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[16][50]={7,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][50]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][50]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[20][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[21][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[25][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[26][50]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][50]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][50]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{21,1},{0,1,0}}
 MapToConvert[29][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][50]={1,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][50]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][50]={6,0,0,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][50]={6,0,0,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][50]={6,0,0,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][50]={6,0,5,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[43][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[45][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][50]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[47][50]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][50]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][50]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[50][50]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][50]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][50]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][50]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][50]={6,0,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][50]={6,0,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][50]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[58][50]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[59][50]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][50]={0,-1,5,{{0,-1},{0,-1},{1,1}},{42,1},{0,0,0}}
 MapToConvert[61][50]={0,-1,5,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[62][50]={0,-1,5,{{1,2},{1,3},{1,1}},{7,1},{0,0,0}}
 MapToConvert[63][50]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[64][50]={0,-1,5,{{1,2},{1,3},{1,1}},{9,1},{0,0,0}}
 MapToConvert[65][50]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[66][50]={0,-1,5,{{1,2},{0,-1},{1,1}},{19,1},{0,0,0}}
 MapToConvert[67][50]={0,-1,5,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[68][50]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][50]={3,2,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[70][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][50]={2,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[73][50]={1,-1,5,{{0,-1},{1,3},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[74][50]={1,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][50]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{0,0,0}}
 MapToConvert[76][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][50]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[83][50]={3,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][50]={4,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][50]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[86][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][50]={3,2,5,{{0,-1},{0,-1},{0,-1}},{0,1},{1,0,1}}
 MapToConvert[92][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][50]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[118][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][50]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[121][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,1,1}}
 MapToConvert[136][50]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][50]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][50]={4,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][50]={4,-1,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[140][50]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[141][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[142][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][50]={3,2,2,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[147][50]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][50]={3,2,2,{{0,-1},{0,-1},{0,-1}},{11,1},{0,0,1}}
 MapToConvert[151][50]={0,5,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[152][50]={0,5,2,{{1,5},{0,-1},{0,-1}},{10,1},{0,1,0}}
 MapToConvert[153][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[157][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][50]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][50]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[9][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][51]={4,3,0,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[11][51]={4,3,0,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[12][51]={4,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][51]={4,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][51]={5,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][51]={8,-1,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[16][51]={4,-1,0,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[17][51]={3,-1,0,{{1,2},{1,0},{1,1}},{7,1},{0,0,0}}
 MapToConvert[18][51]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][51]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[23][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[26][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[29][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[31][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][51]={0,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][51]={6,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][51]={6,0,0,{{0,-1},{1,3},{1,4}},{8,1},{0,0,0}}
 MapToConvert[40][51]={6,0,0,{{0,-1},{1,3},{1,4}},{18,1},{0,0,0}}
 MapToConvert[41][51]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][51]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][51]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[44][51]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][51]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[46][51]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][51]={3,3,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[48][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][51]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][51]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][51]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[52][51]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][51]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][51]={3,-1,5,{{0,-1},{1,3},{1,4}},{19,1},{0,0,0}}
 MapToConvert[55][51]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][51]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][51]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][51]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[59][51]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][51]={0,-1,5,{{0,-1},{1,3},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[61][51]={0,-1,5,{{1,2},{1,3},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[62][51]={0,-1,5,{{1,2},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[63][51]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][51]={3,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[65][51]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][51]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][51]={3,3,5,{{0,-1},{0,-1},{1,4}},{4,1},{0,0,0}}
 MapToConvert[68][51]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[69][51]={0,-1,5,{{1,5},{1,3},{1,4}},{7,1},{0,0,0}}
 MapToConvert[70][51]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][51]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][51]={2,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[73][51]={1,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[74][51]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[75][51]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][51]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][51]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][51]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][51]={3,2,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[80][51]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][51]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][51]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][51]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[84][51]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][51]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[86][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[89][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[98][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][51]={3,2,2,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[117][51]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[135][51]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[136][51]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][51]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[138][51]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][51]={4,-1,2,{{0,-1},{0,-1},{1,1}},{21,1},{0,0,0}}
 MapToConvert[140][51]={3,-1,2,{{1,2},{0,-1},{0,-1}},{16,1},{0,1,0}}
 MapToConvert[141][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[146][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[147][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][51]={3,2,2,{{0,-1},{0,-1},{0,-1}},{28,1},{0,0,0}}
 MapToConvert[149][51]={3,2,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][51]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[153][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[154][51]={3,2,2,{{0,-1},{0,-1},{0,-1}},{28,1},{1,0,1}}
 MapToConvert[155][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][51]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][51]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[6][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][52]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[8][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[12][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[13][52]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[14][52]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[15][52]={3,3,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][52]={3,3,0,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[17][52]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[18][52]={3,3,0,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[19][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[20][52]={3,3,17,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[21][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][52]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[30][52]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[31][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[35][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][52]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][52]={4,3,17,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[38][52]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[39][52]={6,0,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][52]={6,0,0,{{1,2},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[41][52]={6,0,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][52]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][52]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][52]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][52]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][52]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][52]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[48][52]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][52]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][52]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[51][52]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][52]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][52]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][52]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][52]={3,-1,5,{{0,-1},{0,-1},{1,4}},{7,1},{0,0,0}}
 MapToConvert[56][52]={3,-1,5,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][52]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[58][52]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][52]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][52]={0,3,5,{{0,-1},{1,3},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[61][52]={0,-1,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][52]={0,-1,5,{{1,2},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[63][52]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][52]={0,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][52]={0,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][52]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][52]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][52]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][52]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][52]={10,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[71][52]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[72][52]={10,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][52]={2,-1,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][52]={1,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][52]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][52]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][52]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[78][52]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][52]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][52]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][52]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[82][52]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][52]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[84][52]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][52]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[86][52]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][52]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[91][52]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][52]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,1}}
 MapToConvert[100][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][52]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][52]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[116][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[117][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][52]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,1,1}}
 MapToConvert[134][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[136][52]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][52]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[138][52]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][52]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][52]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[150][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][52]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][52]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][53]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[5][53]={3,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][53]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][53]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][53]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][53]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[12][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[13][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][53]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][53]={3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[20][53]={3,3,17,{{0,-1},{0,-1},{0,-1}},{21,1},{0,1,0}}
 MapToConvert[21][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[22][53]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][53]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[34][53]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[35][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][53]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][53]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][53]={3,-1,17,{{0,-1},{1,3},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[39][53]={6,0,17,{{1,2},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[40][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][53]={3,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[43][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[44][53]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][53]={4,3,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[46][53]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][53]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][53]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][53]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[51][53]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][53]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][53]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][53]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[56][53]={3,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][53]={3,-1,5,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[58][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[59][53]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][53]={0,3,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][53]={0,-1,5,{{0,-1},{1,3},{1,4}},{1,1},{0,0,0}}
 MapToConvert[62][53]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][53]={10,3,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[64][53]={9,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[65][53]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[66][53]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][53]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][53]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][53]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][53]={14,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[71][53]={10,-1,5,{{0,-1},{1,3},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[72][53]={11,-1,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][53]={1,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][53]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[75][53]={0,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][53]={1,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[77][53]={1,3,5,{{1,2},{1,0},{1,1}},{41,1},{0,0,0}}
 MapToConvert[78][53]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][53]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[80][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][53]={0,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][53]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][53]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][53]={1,3,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[86][53]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][53]={0,2,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[91][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[92][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][53]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[94][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][53]={3,2,2,{{0,-1},{0,-1},{0,-1}},{0,1},{0,1,0}}
 MapToConvert[115][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][53]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[133][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[134][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][53]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][53]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][53]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][53]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[139][53]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[140][53]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[141][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[149][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][53]={3,2,2,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[152][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][53]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][53]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][54]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[5][54]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[6][54]={4,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[7][54]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][54]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[9][54]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][54]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[11][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[17][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[18][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][54]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,1}}
 MapToConvert[24][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[26][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][54]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[28][54]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[29][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][54]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][54]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[38][54]={1,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][54]={3,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][54]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][54]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[42][54]={3,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[43][54]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][54]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][54]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][54]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[47][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{19,1},{0,0,0}}
 MapToConvert[49][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][54]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[51][54]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][54]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[53][54]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][54]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][54]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][54]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][54]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[58][54]={3,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[59][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][54]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][54]={0,3,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][54]={1,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][54]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][54]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][54]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][54]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][54]={12,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[68][54]={12,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[69][54]={9,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[70][54]={9,-1,5,{{1,2},{0,-1},{1,1}},{21,1},{0,0,0}}
 MapToConvert[71][54]={10,-1,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][54]={11,-1,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][54]={1,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[75][54]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][54]={0,-1,5,{{1,2},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[77][54]={1,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][54]={2,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[79][54]={0,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[80][54]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{1,0,0}}
 MapToConvert[82][54]={0,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[85][54]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][54]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][54]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[90][54]={0,3,5,{{0,-1},{0,-1},{1,4}},{15,1},{0,0,0}}
 MapToConvert[91][54]={3,2,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][54]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[94][54]={1,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][54]={0,2,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[110][54]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[111][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[116][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[132][54]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[133][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[135][54]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[136][54]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][54]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[138][54]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][54]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][54]={3,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][54]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][54]={3,2,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][54]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][54]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][54]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[4][55]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][55]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[6][55]={3,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[7][55]={4,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[8][55]={3,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[9][55]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][55]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{2,1},{0,1,0}}
 MapToConvert[11][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][55]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][55]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[25][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][55]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[27][55]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[29][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[32][55]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[33][55]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[34][55]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][55]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[36][55]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[37][55]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][55]={0,-1,17,{{0,-1},{1,3},{1,4}},{42,1},{0,0,0}}
 MapToConvert[39][55]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][55]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][55]={4,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][55]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][55]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][55]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][55]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[46][55]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][55]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][55]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][55]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[50][55]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][55]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][55]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][55]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][55]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][55]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][55]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][55]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][55]={0,-1,5,{{0,-1},{1,3},{1,4}},{9,1},{0,0,0}}
 MapToConvert[59][55]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][55]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][55]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][55]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[63][55]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][55]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][55]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][55]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][55]={13,-1,5,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[68][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[69][55]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][55]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][55]={14,-1,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][55]={1,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][55]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][55]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][55]={1,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][55]={1,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][55]={1,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][55]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][55]={0,-1,5,{{0,-1},{1,3},{1,1}},{25,1},{0,0,0}}
 MapToConvert[80][55]={0,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[81][55]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][55]={0,3,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][55]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[84][55]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][55]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][55]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[87][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[88][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[90][55]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[92][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[94][55]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[96][55]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[97][55]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[98][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[110][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[111][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][55]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[132][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][55]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][55]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][55]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][55]={8,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[138][55]={4,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][55]={3,-1,2,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[140][55]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][55]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[142][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[143][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[146][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[148][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][55]={0,5,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][55]={0,5,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][55]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][55]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][55]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][56]={0,-1,17,{{0,-1},{0,-1},{1,4}},{9,1},{0,0,0}}
 MapToConvert[5][56]={0,-1,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[6][56]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][56]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[8][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[9][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][56]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][56]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[18][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[19][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][56]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[25][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][56]={3,-1,17,{{0,-1},{0,-1},{1,4}},{33,1},{0,0,0}}
 MapToConvert[27][56]={3,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[28][56]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[29][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[30][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[33][56]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][56]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[35][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][56]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][56]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][56]={3,-1,17,{{0,-1},{1,3},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[39][56]={3,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][56]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][56]={4,3,17,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[42][56]={5,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][56]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][56]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[45][56]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][56]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][56]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][56]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][56]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][56]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][56]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][56]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[53][56]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][56]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[55][56]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][56]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][56]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][56]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][56]={1,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[60][56]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][56]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][56]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][56]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][56]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][56]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][56]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][56]={12,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][56]={14,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][56]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][56]={10,-1,5,{{1,2},{0,-1},{1,1}},{21,1},{0,0,0}}
 MapToConvert[72][56]={10,-1,5,{{1,2},{1,3},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[73][56]={11,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[74][56]={11,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[75][56]={1,3,5,{{1,2},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[76][56]={4,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][56]={1,3,5,{{1,2},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[78][56]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][56]={2,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][56]={0,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][56]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[82][56]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][56]={1,3,5,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][56]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[85][56]={0,-1,5,{{1,2},{1,0},{1,1}},{9,1},{0,0,0}}
 MapToConvert[86][56]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[87][56]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[88][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][56]={4,2,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[92][56]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,1,0}}
 MapToConvert[93][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][56]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[98][56]={4,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][56]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][56]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[133][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[134][56]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[135][56]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[136][56]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][56]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[138][56]={6,-1,2,{{0,-1},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[139][56]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][56]={4,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[141][56]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[142][56]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][56]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[144][56]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{1,0,0}}
 MapToConvert[145][56]={0,5,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][56]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][56]={0,-1,2,{{0,-1},{0,-1},{1,1}},{13,1},{0,0,0}}
 MapToConvert[152][56]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[153][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][56]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,1}}
 MapToConvert[178][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[179][56]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[4][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[5][57]={1,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[6][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[7][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[10][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[20][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[21][57]={4,3,17,{{0,-1},{0,-1},{0,-1}},{43,1},{1,0,0}}
 MapToConvert[22][57]={4,3,17,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[23][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][57]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][57]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][57]={0,-1,17,{{1,2},{0,-1},{1,1}},{1,1},{0,0,0}}
 MapToConvert[28][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[30][57]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[31][57]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][57]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[33][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[34][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[35][57]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][57]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[38][57]={4,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[39][57]={3,-1,17,{{1,5},{0,-1},{1,4}},{7,1},{0,0,0}}
 MapToConvert[40][57]={3,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[41][57]={4,3,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[42][57]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][57]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][57]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[46][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[47][57]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][57]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][57]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][57]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][57]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][57]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][57]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][57]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][57]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][57]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][57]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[58][57]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][57]={11,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[60][57]={9,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][57]={11,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[62][57]={9,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[63][57]={9,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[64][57]={9,-1,5,{{1,5},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[65][57]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][57]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][57]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[68][57]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][57]={9,3,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[70][57]={5,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[71][57]={5,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[72][57]={4,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][57]={4,3,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[74][57]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][57]={4,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[76][57]={2,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][57]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][57]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][57]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[80][57]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][57]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][57]={0,-1,5,{{1,2},{0,-1},{1,1}},{31,1},{0,0,0}}
 MapToConvert[83][57]={0,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][57]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][57]={0,-1,5,{{0,-1},{0,-1},{1,1}},{25,1},{0,0,0}}
 MapToConvert[86][57]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[87][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][57]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{15,1},{0,0,0}}
 MapToConvert[90][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[91][57]={1,3,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[92][57]={0,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][57]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][57]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[95][57]={0,-1,5,{{0,-1},{1,3},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[96][57]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][57]={4,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][57]={4,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[131][57]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[132][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][57]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[134][57]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][57]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][57]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][57]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][57]={7,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[139][57]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][57]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][57]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][57]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[143][57]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][57]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][57]={0,5,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[146][57]={0,5,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][57]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][57]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[149][57]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][57]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][57]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[154][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][57]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][57]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[179][57]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,1,0}}
 MapToConvert[4][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][58]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][58]={0,3,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[7][58]={0,3,17,{{1,5},{0,-1},{1,4}},{4,1},{0,0,0}}
 MapToConvert[8][58]={0,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[9][58]={0,3,17,{{1,5},{0,-1},{1,4}},{33,1},{0,0,0}}
 MapToConvert[10][58]={3,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][58]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[13][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][58]={0,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[21][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][58]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[24][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[26][58]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][58]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[28][58]={3,-1,17,{{0,-1},{1,3},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[29][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[30][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][58]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[33][58]={4,3,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[34][58]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[35][58]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][58]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[37][58]={3,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][58]={1,-1,17,{{1,5},{0,-1},{1,4}},{41,1},{0,0,0}}
 MapToConvert[39][58]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][58]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[41][58]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][58]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][58]={4,3,17,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[44][58]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][58]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,1,1}}
 MapToConvert[46][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[48][58]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][58]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][58]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][58]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][58]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][58]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[54][58]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][58]={4,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][58]={10,-1,5,{{1,5},{0,-1},{1,4}},{8,1},{0,0,0}}
 MapToConvert[57][58]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][58]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][58]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][58]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][58]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][58]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][58]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][58]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][58]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][58]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][58]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][58]={9,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[69][58]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][58]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][58]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][58]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][58]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][58]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][58]={3,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[76][58]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][58]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[78][58]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][58]={1,3,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[80][58]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[81][58]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[82][58]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][58]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][58]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[85][58]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][58]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[93][58]={1,3,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[94][58]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][58]={0,-1,5,{{0,-1},{1,3},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[96][58]={3,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][58]={0,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][58]={0,-1,5,{{1,2},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[99][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][58]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[101][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[102][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][58]={4,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][58]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][58]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][58]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][58]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][58]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][58]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][58]={4,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[140][58]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][58]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[142][58]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][58]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][58]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][58]={0,-1,2,{{0,-1},{1,3},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[146][58]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][58]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][58]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][58]={0,3,2,{{0,-1},{1,3},{1,4}},{13,1},{0,0,0}}
 MapToConvert[150][58]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][58]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][58]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[153][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][58]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][58]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[4][59]={1,3,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[5][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][59]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][59]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][59]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][59]={0,-1,17,{{1,2},{0,-1},{1,1}},{42,1},{0,0,0}}
 MapToConvert[11][59]={3,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][59]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[16][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][59]={3,3,17,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[18][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[20][59]={4,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[21][59]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[24][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][59]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[26][59]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][59]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][59]={0,3,17,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][59]={0,-1,17,{{1,2},{0,-1},{0,-1}},{7,1},{0,1,0}}
 MapToConvert[30][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][59]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][59]={1,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][59]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][59]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[36][59]={1,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][59]={1,3,17,{{1,5},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[38][59]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][59]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][59]={5,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][59]={4,3,17,{{1,5},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[42][59]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][59]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[44][59]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[45][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][59]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][59]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][59]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][59]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][59]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][59]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[53][59]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][59]={4,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][59]={10,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][59]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][59]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][59]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][59]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][59]={9,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[61][59]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][59]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][59]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][59]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][59]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][59]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][59]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][59]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[69][59]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][59]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][59]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[72][59]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][59]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[74][59]={4,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[75][59]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][59]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[77][59]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][59]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][59]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[80][59]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][59]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[82][59]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][59]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[84][59]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[86][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][59]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[90][59]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{1,0,0}}
 MapToConvert[91][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[93][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[94][59]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][59]={1,3,5,{{0,-1},{1,3},{1,4}},{14,1},{0,0,0}}
 MapToConvert[96][59]={1,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][59]={0,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][59]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][59]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[131][59]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{10,1},{0,0,0}}
 MapToConvert[132][59]={3,-1,2,{{0,-1},{1,3},{1,4}},{9,1},{0,0,0}}
 MapToConvert[133][59]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][59]={3,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[135][59]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][59]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][59]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][59]={7,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][59]={4,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][59]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[141][59]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][59]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][59]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][59]={0,-1,2,{{0,-1},{1,3},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[145][59]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][59]={0,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[147][59]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][59]={4,3,2,{{0,-1},{1,3},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[149][59]={4,3,2,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[150][59]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[151][59]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][59]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[153][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][59]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][59]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[4][60]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][60]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[6][60]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][60]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][60]={1,3,17,{{0,-1},{0,-1},{1,1}},{41,1},{0,0,0}}
 MapToConvert[9][60]={1,3,17,{{1,2},{0,-1},{1,1}},{40,1},{0,0,0}}
 MapToConvert[10][60]={2,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][60]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][60]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[14][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][60]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[16][60]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{10,1},{1,0,0}}
 MapToConvert[17][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[18][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[19][60]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[20][60]={4,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][60]={3,-1,17,{{1,2},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[22][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][60]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[25][60]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][60]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][60]={1,3,17,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[28][60]={1,-1,17,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][60]={1,-1,17,{{1,2},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[30][60]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][60]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,1,0}}
 MapToConvert[34][60]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][60]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][60]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][60]={3,-1,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[38][60]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{1,0,1}}
 MapToConvert[40][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][60]={0,-1,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[42][60]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][60]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[44][60]={0,-1,17,{{1,2},{0,-1},{1,1}},{7,1},{0,0,0}}
 MapToConvert[45][60]={3,-1,17,{{1,2},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[46][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[48][60]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][60]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][60]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][60]={6,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][60]={6,0,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[53][60]={6,0,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[54][60]={3,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[55][60]={4,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][60]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[57][60]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][60]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[59][60]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][60]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][60]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][60]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][60]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][60]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][60]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[66][60]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][60]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][60]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][60]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][60]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][60]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[73][60]={3,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[74][60]={4,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[75][60]={3,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][60]={3,3,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[77][60]={4,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[78][60]={3,3,5,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[79][60]={3,-1,5,{{1,2},{1,3},{1,1}},{1,1},{0,0,0}}
 MapToConvert[80][60]={5,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[81][60]={4,-1,5,{{1,2},{1,0},{1,1}},{25,1},{0,0,0}}
 MapToConvert[82][60]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][60]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][60]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][60]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[86][60]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][60]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][60]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[92][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,1}}
 MapToConvert[95][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[96][60]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][60]={1,3,5,{{0,-1},{0,-1},{1,4}},{41,1},{0,0,0}}
 MapToConvert[98][60]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][60]={3,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][60]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[101][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][60]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][60]={4,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][60]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][60]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][60]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][60]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][60]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][60]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][60]={4,-1,2,{{0,-1},{1,3},{1,4}},{44,1},{0,0,0}}
 MapToConvert[140][60]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][60]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][60]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][60]={0,3,2,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[144][60]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][60]={0,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[146][60]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][60]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][60]={3,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][60]={4,3,2,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][60]={5,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][60]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[152][60]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][60]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[154][60]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][60]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][60]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[4][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[5][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[7][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[8][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[9][61]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][61]={1,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][61]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][61]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][61]={3,-1,17,{{0,-1},{1,3},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[14][61]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][61]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[16][61]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][61]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][61]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][61]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[20][61]={0,-1,17,{{1,2},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[21][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[22][61]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[23][61]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][61]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][61]={1,3,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[26][61]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][61]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][61]={1,3,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[29][61]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][61]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[31][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[34][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,1}}
 MapToConvert[36][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[37][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[41][61]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[42][61]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][61]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][61]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[45][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[46][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][61]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][61]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][61]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[50][61]={6,0,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][61]={6,0,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][61]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][61]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][61]={3,-1,5,{{0,-1},{1,0},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[55][61]={3,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[56][61]={10,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][61]={3,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[58][61]={11,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[59][61]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][61]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][61]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][61]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[63][61]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][61]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][61]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[66][61]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][61]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][61]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][61]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][61]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[71][61]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][61]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[73][61]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[74][61]={4,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[75][61]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][61]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[77][61]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][61]={3,3,5,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][61]={5,-1,5,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[80][61]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[81][61]={3,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][61]={0,-1,5,{{1,2},{1,0},{1,1}},{9,1},{0,0,0}}
 MapToConvert[83][61]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][61]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][61]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][61]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[87][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[89][61]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[90][61]={1,3,5,{{0,-1},{1,3},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[91][61]={1,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[96][61]={2,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][61]={1,3,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[98][61]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[99][61]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[100][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[101][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[130][61]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[131][61]={4,3,2,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[132][61]={4,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[133][61]={6,0,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][61]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][61]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][61]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][61]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][61]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][61]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][61]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][61]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][61]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][61]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][61]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][61]={0,-1,2,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[146][61]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][61]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][61]={4,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[149][61]={4,3,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[150][61]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][61]={1,3,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[152][61]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][61]={0,-1,2,{{1,2},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[154][61]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][61]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][61]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[10][62]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][62]={0,-1,17,{{1,5},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[12][62]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][62]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][62]={0,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[15][62]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][62]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][62]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][62]={3,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[19][62]={3,-1,17,{{1,2},{0,-1},{1,1}},{9,1},{0,0,0}}
 MapToConvert[20][62]={3,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[21][62]={0,5,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][62]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[24][62]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][62]={1,3,17,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[26][62]={3,3,17,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[27][62]={1,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][62]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[29][62]={0,3,17,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[30][62]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][62]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][62]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[33][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][62]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][62]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][62]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[44][62]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[46][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][62]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][62]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][62]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][62]={6,0,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][62]={6,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][62]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[53][62]={6,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][62]={6,0,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[55][62]={3,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][62]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][62]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[58][62]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][62]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][62]={10,3,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[61][62]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][62]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][62]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][62]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][62]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][62]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[67][62]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][62]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][62]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[70][62]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][62]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][62]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][62]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][62]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][62]={3,-1,5,{{0,-1},{1,0},{1,1}},{1,1},{0,0,0}}
 MapToConvert[76][62]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][62]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][62]={4,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][62]={3,-1,5,{{1,2},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[80][62]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][62]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][62]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][62]={0,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][62]={0,-1,5,{{1,2},{0,-1},{1,1}},{25,1},{0,0,0}}
 MapToConvert[85][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[88][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[89][62]={0,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[90][62]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][62]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[92][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[94][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[97][62]={2,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[98][62]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][62]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][62]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][62]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][62]={3,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][62]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][62]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[135][62]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][62]={6,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][62]={8,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][62]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][62]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][62]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][62]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][62]={4,3,2,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[143][62]={1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][62]={0,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[145][62]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][62]={0,-1,2,{{0,-1},{1,3},{1,4}},{9,1},{0,0,0}}
 MapToConvert[147][62]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[148][62]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][62]={4,3,2,{{0,-1},{0,-1},{1,4}},{8,1},{0,0,0}}
 MapToConvert[150][62]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][62]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][62]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][62]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][62]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][62]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{42,1},{0,1,1}}
 MapToConvert[156][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][62]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][62]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][63]={3,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[11][63]={1,3,17,{{1,5},{0,-1},{1,4}},{40,1},{0,0,0}}
 MapToConvert[12][63]={4,3,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[13][63]={4,3,17,{{0,-1},{1,0},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[14][63]={0,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[15][63]={1,3,17,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[16][63]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][63]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][63]={4,3,17,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[19][63]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][63]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[21][63]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][63]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][63]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][63]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][63]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][63]={3,-1,17,{{1,2},{0,-1},{1,1}},{9,1},{0,0,0}}
 MapToConvert[27][63]={1,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][63]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][63]={0,3,17,{{0,-1},{0,-1},{1,1}},{31,1},{0,0,0}}
 MapToConvert[30][63]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][63]={0,-1,17,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][63]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][63]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[40][63]={4,3,17,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[41][63]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[42][63]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][63]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[44][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[46][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][63]={6,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][63]={6,0,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][63]={6,0,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][63]={6,0,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][63]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[56][63]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][63]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][63]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][63]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][63]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][63]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[64][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][63]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][63]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][63]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][63]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][63]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][63]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{21,1},{0,0,0}}
 MapToConvert[73][63]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][63]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][63]={3,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[76][63]={6,0,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[77][63]={3,-1,5,{{1,2},{0,-1},{1,1}},{13,1},{0,0,0}}
 MapToConvert[78][63]={4,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][63]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][63]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][63]={3,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[82][63]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][63]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[86][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][63]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][63]={0,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[90][63]={0,3,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[91][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[96][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[97][63]={1,3,5,{{1,5},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][63]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][63]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[100][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[129][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][63]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][63]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][63]={4,-1,2,{{0,-1},{0,-1},{1,4}},{43,1},{0,0,0}}
 MapToConvert[133][63]={7,-1,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[134][63]={6,0,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[135][63]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[136][63]={6,0,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][63]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][63]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][63]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][63]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[141][63]={3,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[142][63]={4,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[143][63]={1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][63]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][63]={0,-1,2,{{0,-1},{1,3},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[146][63]={3,-1,2,{{1,2},{0,-1},{1,4}},{9,1},{0,0,0}}
 MapToConvert[147][63]={3,-1,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[148][63]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][63]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][63]={4,3,2,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[151][63]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][63]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[153][63]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][63]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[156][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][63]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][63]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[9][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][64]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][64]={0,3,17,{{0,-1},{0,-1},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[12][64]={4,3,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[13][64]={4,3,17,{{0,-1},{1,0},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[14][64]={4,3,17,{{1,5},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][64]={3,3,17,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[16][64]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][64]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][64]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][64]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][64]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][64]={5,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][64]={11,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][64]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][64]={0,3,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[25][64]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][64]={3,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][64]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[28][64]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][64]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][64]={1,3,17,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[31][64]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][64]={1,-1,17,{{0,-1},{0,-1},{1,1}},{24,1},{0,0,0}}
 MapToConvert[33][64]={0,5,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,1,0}}
 MapToConvert[36][64]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{1,0,0}}
 MapToConvert[37][64]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][64]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][64]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][64]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][64]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][64]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][64]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,1}}
 MapToConvert[45][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[47][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[48][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][64]={6,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][64]={6,0,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][64]={6,0,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][64]={6,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][64]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[58][64]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][64]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[60][64]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[62][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[69][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[71][64]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[73][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][64]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][64]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][64]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][64]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][64]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[82][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[83][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,1,1}}
 MapToConvert[85][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[87][64]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[88][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][64]={0,-1,5,{{1,5},{1,3},{1,4}},{9,1},{0,0,0}}
 MapToConvert[90][64]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[91][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{23,1},{0,0,0}}
 MapToConvert[94][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[97][64]={1,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][64]={0,3,5,{{1,5},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[99][64]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{1,0,0}}
 MapToConvert[101][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[130][64]={0,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[131][64]={4,3,2,{{1,5},{1,3},{1,4}},{40,1},{0,0,0}}
 MapToConvert[132][64]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[133][64]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][64]={6,4,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][64]={6,0,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[136][64]={7,-1,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[137][64]={5,-1,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[138][64]={4,3,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[139][64]={4,3,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[140][64]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][64]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][64]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][64]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][64]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[145][64]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][64]={3,-1,2,{{1,2},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[147][64]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[148][64]={3,-1,2,{{0,-1},{0,-1},{1,4}},{9,1},{0,0,0}}
 MapToConvert[149][64]={3,-1,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[150][64]={3,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[151][64]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][64]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][64]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[154][64]={0,3,2,{{1,2},{1,0},{1,1}},{4,1},{0,0,0}}
 MapToConvert[155][64]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][64]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][64]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[9][65]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][65]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][65]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][65]={4,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][65]={4,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][65]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[15][65]={3,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[16][65]={0,3,17,{{1,5},{0,-1},{1,4}},{4,1},{0,0,0}}
 MapToConvert[17][65]={1,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][65]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][65]={1,3,17,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[20][65]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][65]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][65]={4,3,17,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[23][65]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][65]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][65]={3,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[26][65]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][65]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][65]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][65]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][65]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][65]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][65]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[33][65]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[34][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][65]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[37][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[38][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][65]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][65]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[41][65]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][65]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][65]={6,0,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][65]={6,0,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[47][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][65]={6,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[50][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[52][65]={6,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][65]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[57][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][65]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][65]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[60][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[61][65]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][65]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[63][65]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][65]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][65]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[66][65]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][65]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][65]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[72][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][65]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][65]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][65]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[78][65]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][65]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[80][65]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][65]={4,-1,5,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][65]={3,-1,5,{{1,2},{0,-1},{1,1}},{9,1},{0,0,0}}
 MapToConvert[83][65]={3,3,5,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][65]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][65]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][65]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,1}}
 MapToConvert[88][65]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][65]={0,3,5,{{0,-1},{1,3},{1,4}},{25,1},{0,0,0}}
 MapToConvert[90][65]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[91][65]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,1,1}}
 MapToConvert[92][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[97][65]={1,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][65]={3,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][65]={4,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[130][65]={1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][65]={3,-1,2,{{1,2},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[132][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][65]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][65]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][65]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][65]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[137][65]={5,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[138][65]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][65]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][65]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][65]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[142][65]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][65]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][65]={0,5,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][65]={0,5,2,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[146][65]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][65]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][65]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][65]={3,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[150][65]={0,3,2,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[151][65]={0,3,2,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[152][65]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][65]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][65]={1,-1,2,{{0,-1},{0,-1},{1,1}},{2,1},{0,0,0}}
 MapToConvert[155][65]={1,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][65]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][65]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[8][66]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][66]={0,-1,17,{{0,-1},{0,-1},{1,4}},{31,1},{0,0,0}}
 MapToConvert[10][66]={1,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[11][66]={1,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[12][66]={0,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[13][66]={3,-1,17,{{1,5},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[14][66]={3,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][66]={3,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][66]={3,3,17,{{0,-1},{1,0},{0,-1}},{33,1},{0,0,0}}
 MapToConvert[17][66]={1,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[18][66]={1,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][66]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][66]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][66]={4,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[22][66]={3,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[23][66]={3,-1,17,{{1,2},{0,-1},{1,1}},{7,1},{0,0,0}}
 MapToConvert[24][66]={3,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[25][66]={4,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[26][66]={1,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][66]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][66]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][66]={1,3,17,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[30][66]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][66]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][66]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][66]={3,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[34][66]={3,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][66]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[36][66]={3,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[37][66]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[38][66]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][66]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][66]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[42][66]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[43][66]={3,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][66]={6,0,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[45][66]={6,0,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][66]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[47][66]={6,0,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][66]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][66]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[62][66]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][66]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][66]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][66]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][66]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][66]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[68][66]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][66]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][66]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[75][66]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][66]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][66]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{18,1},{0,0,0}}
 MapToConvert[81][66]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][66]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][66]={4,-1,5,{{0,-1},{1,3},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[84][66]={3,3,5,{{1,2},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[85][66]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][66]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{25,1},{0,0,0}}
 MapToConvert[87][66]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][66]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{13,1},{0,0,0}}
 MapToConvert[89][66]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][66]={10,3,5,{{0,-1},{1,3},{1,4}},{43,1},{0,0,0}}
 MapToConvert[91][66]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][66]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[93][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[98][66]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][66]={3,3,5,{{1,2},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[100][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][66]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][66]={3,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[132][66]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][66]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][66]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[135][66]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][66]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][66]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][66]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][66]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][66]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][66]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][66]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][66]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][66]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][66]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][66]={0,-1,2,{{0,-1},{1,3},{1,4}},{45,1},{0,0,0}}
 MapToConvert[147][66]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][66]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][66]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[150][66]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][66]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][66]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][66]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[154][66]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][66]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][66]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[157][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[158][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][66]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][66]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[7][67]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][67]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][67]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[10][67]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[11][67]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][67]={0,-1,17,{{0,-1},{1,0},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[13][67]={0,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[14][67]={3,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][67]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][67]={4,3,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[17][67]={4,3,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[18][67]={1,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[19][67]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[20][67]={3,-1,17,{{1,2},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[21][67]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][67]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][67]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][67]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][67]={1,3,17,{{0,-1},{1,0},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[26][67]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][67]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][67]={2,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][67]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][67]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[31][67]={1,-1,17,{{0,-1},{1,3},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[32][67]={3,-1,17,{{1,2},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[33][67]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][67]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][67]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][67]={3,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][67]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[38][67]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,1}}
 MapToConvert[39][67]={3,-1,17,{{0,-1},{1,3},{1,4}},{9,1},{1,0,0}}
 MapToConvert[40][67]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][67]={3,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][67]={3,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][67]={3,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][67]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][67]={6,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][67]={6,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][67]={6,0,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[54][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[59][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][67]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][67]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][67]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][67]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][67]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[66][67]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][67]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][67]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[69][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][67]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[72][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][67]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][67]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][67]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][67]={4,-1,5,{{1,2},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[84][67]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][67]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][67]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[87][67]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][67]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][67]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[90][67]={11,-1,5,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[91][67]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][67]={1,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[93][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[95][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[97][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][67]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[129][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[130][67]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[131][67]={3,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[132][67]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][67]={7,-1,2,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[134][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][67]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][67]={4,3,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[137][67]={3,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[138][67]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][67]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[140][67]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][67]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[142][67]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][67]={0,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[144][67]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][67]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][67]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[148][67]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][67]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][67]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[152][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][67]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][67]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[155][67]={1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][67]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][67]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,1,0}}
 MapToConvert[158][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][67]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][67]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[8][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[9][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[10][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][68]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[12][68]={0,-1,17,{{0,-1},{1,0},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[13][68]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][68]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][68]={4,-1,17,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[16][68]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][68]={4,3,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[18][68]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][68]={4,3,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[20][68]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][68]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[22][68]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][68]={1,-1,17,{{0,-1},{1,0},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[24][68]={1,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][68]={1,3,17,{{0,-1},{1,0},{1,1}},{40,1},{0,0,0}}
 MapToConvert[26][68]={0,3,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[27][68]={0,3,17,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[28][68]={0,3,17,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[29][68]={1,3,17,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[30][68]={0,3,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[31][68]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[32][68]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][68]={0,-1,17,{{0,-1},{1,3},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[34][68]={3,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[35][68]={3,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[36][68]={3,-1,17,{{1,2},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[37][68]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][68]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][68]={3,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[40][68]={3,3,17,{{1,2},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][68]={3,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[42][68]={3,-1,17,{{1,2},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[43][68]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][68]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][68]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[46][68]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][68]={3,-1,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[48][68]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][68]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][68]={6,0,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][68]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][68]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[65][68]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[78][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[82][68]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][68]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][68]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][68]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[86][68]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][68]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][68]={0,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][68]={0,3,5,{{1,5},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[90][68]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][68]={9,3,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[92][68]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][68]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[99][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[100][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[131][68]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][68]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][68]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][68]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][68]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][68]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][68]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][68]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][68]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][68]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][68]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][68]={0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][68]={3,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][68]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][68]={0,3,2,{{0,-1},{1,3},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[146][68]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][68]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,1,1}}
 MapToConvert[149][68]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[150][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][68]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][68]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[153][68]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][68]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][68]={1,-1,2,{{1,2},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[157][68]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[159][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][68]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[161][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[163][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][68]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][68]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,1,0}}
 MapToConvert[10][69]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[12][69]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][69]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][69]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[15][69]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][69]={3,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][69]={3,-1,17,{{1,5},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[18][69]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[19][69]={4,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][69]={4,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][69]={1,3,17,{{1,5},{0,-1},{1,4}},{2,1},{0,0,0}}
 MapToConvert[22][69]={0,3,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[23][69]={0,3,17,{{1,5},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[24][69]={0,3,17,{{0,-1},{1,0},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[25][69]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][69]={3,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][69]={3,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][69]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][69]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][69]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[31][69]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][69]={0,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][69]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][69]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[35][69]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[36][69]={3,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][69]={3,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[38][69]={3,-1,17,{{1,2},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[39][69]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[40][69]={3,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[41][69]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][69]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][69]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[44][69]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][69]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[46][69]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][69]={0,-1,17,{{0,-1},{0,-1},{1,4}},{1,1},{0,0,0}}
 MapToConvert[48][69]={4,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[49][69]={4,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[50][69]={3,-1,5,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[51][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[52][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[58][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{1,0,0}}
 MapToConvert[59][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[61][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][69]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][69]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[67][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[70][69]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][69]={7,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][69]={6,4,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][69]={7,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[75][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[80][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][69]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][69]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][69]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][69]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][69]={1,3,5,{{0,-1},{1,0},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[88][69]={1,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][69]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][69]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][69]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][69]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][69]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][69]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[95][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][69]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[98][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][69]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][69]={1,3,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][69]={0,3,2,{{1,5},{0,-1},{1,4}},{16,1},{0,0,0}}
 MapToConvert[133][69]={0,-1,2,{{1,5},{0,-1},{1,4}},{42,1},{0,0,0}}
 MapToConvert[134][69]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][69]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][69]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][69]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][69]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][69]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[140][69]={3,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][69]={0,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[142][69]={0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][69]={3,3,2,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[144][69]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][69]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][69]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[147][69]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][69]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][69]={0,3,2,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[153][69]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[154][69]={3,-1,2,{{0,-1},{1,0},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[155][69]={0,3,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[156][69]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][69]={0,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[158][69]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][69]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][69]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][69]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[7][70]={3,-1,17,{{0,-1},{1,3},{0,-1}},{8,1},{1,0,1}}
 MapToConvert[8][70]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[9][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[11][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[12][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[13][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][70]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][70]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[16][70]={0,5,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][70]={3,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][70]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][70]={3,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][70]={3,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[21][70]={3,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][70]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][70]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[24][70]={0,-1,17,{{0,-1},{1,0},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[25][70]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][70]={3,3,17,{{0,-1},{1,0},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[27][70]={3,-1,17,{{1,5},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[28][70]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][70]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][70]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][70]={3,-1,17,{{0,-1},{1,3},{1,4}},{1,1},{0,0,0}}
 MapToConvert[34][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][70]={3,-1,17,{{0,-1},{1,3},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[37][70]={3,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][70]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][70]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[40][70]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[41][70]={3,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[42][70]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][70]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][70]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][70]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[50][70]={4,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][70]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][70]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[62][70]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][70]={6,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][70]={7,-1,5,{{1,5},{0,-1},{1,4}},{8,1},{0,0,0}}
 MapToConvert[65][70]={3,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][70]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][70]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][70]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][70]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][70]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][70]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][70]={11,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[73][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][70]={3,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[75][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[77][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][70]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][70]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[81][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][70]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[84][70]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][70]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][70]={4,3,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[87][70]={3,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][70]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[89][70]={0,-1,5,{{1,2},{0,-1},{1,1}},{31,1},{0,0,0}}
 MapToConvert[90][70]={0,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[91][70]={0,-1,5,{{1,2},{1,0},{1,1}},{25,1},{0,0,0}}
 MapToConvert[92][70]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[93][70]={3,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][70]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][70]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[96][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[98][70]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][70]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[100][70]={3,3,5,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[101][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[129][70]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][70]={0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][70]={0,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[135][70]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][70]={4,3,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[137][70]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][70]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][70]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][70]={3,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][70]={3,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[143][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][70]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][70]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[148][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][70]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][70]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1},{1,0,1}}
 MapToConvert[151][70]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[155][70]={0,-1,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[156][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[157][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][70]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[160][70]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[161][70]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,1,0}}
 MapToConvert[162][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][70]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][70]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,1}}
 MapToConvert[7][71]={0,-1,17,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[8][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][71]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[10][71]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{1,0,0}}
 MapToConvert[11][71]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[12][71]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[13][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][71]={0,5,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[16][71]={0,5,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][71]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[18][71]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][71]={0,-1,17,{{1,5},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[20][71]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[21][71]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][71]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[23][71]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][71]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][71]={4,3,17,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[27][71]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][71]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[29][71]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][71]={0,5,17,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[32][71]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][71]={4,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[34][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][71]={0,3,17,{{0,-1},{1,3},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[41][71]={0,-1,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[46][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][71]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][71]={1,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][71]={10,-1,5,{{0,-1},{1,3},{1,4}},{43,1},{0,0,0}}
 MapToConvert[51][71]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][71]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][71]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[55][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[59][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][71]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][71]={6,-1,5,{{0,-1},{1,0},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[63][71]={6,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][71]={6,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][71]={3,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][71]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][71]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][71]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][71]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][71]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][71]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][71]={3,-1,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[73][71]={3,-1,5,{{1,2},{0,-1},{1,1}},{46,1},{0,0,0}}
 MapToConvert[74][71]={4,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[75][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[77][71]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][71]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[82][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][71]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][71]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][71]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][71]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][71]={3,-1,5,{{0,-1},{1,3},{1,4}},{45,1},{0,0,0}}
 MapToConvert[88][71]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][71]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][71]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[91][71]={0,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[92][71]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[93][71]={9,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[94][71]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][71]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[96][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[98][71]={3,-1,5,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[99][71]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][71]={4,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[101][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[129][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[130][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,1,0}}
 MapToConvert[131][71]={2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][71]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[133][71]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][71]={11,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][71]={4,3,2,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][71]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][71]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[138][71]={3,-1,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][71]={3,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[140][71]={3,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][71]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][71]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][71]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][71]={0,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][71]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][71]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[147][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[148][71]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][71]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][71]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][71]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][71]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][71]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][71]={0,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[155][71]={1,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[156][71]={1,-1,2,{{1,2},{1,0},{1,1}},{2,1},{0,0,0}}
 MapToConvert[157][71]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][71]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][71]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[162][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[167][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][71]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][71]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][72]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][72]={0,-1,17,{{0,-1},{0,-1},{1,1}},{9,1},{0,0,0}}
 MapToConvert[11][72]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[12][72]={0,-1,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[13][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{1,0,0}}
 MapToConvert[14][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][72]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][72]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][72]={0,5,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][72]={0,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][72]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][72]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[22][72]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][72]={0,-1,17,{{0,-1},{1,0},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[24][72]={0,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][72]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][72]={0,3,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][72]={3,-1,17,{{1,5},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[28][72]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][72]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][72]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][72]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][72]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][72]={4,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][72]={3,-1,17,{{1,2},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[35][72]={1,3,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[36][72]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[37][72]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[38][72]={0,-1,17,{{1,2},{0,-1},{1,1}},{42,1},{0,0,0}}
 MapToConvert[39][72]={0,-1,17,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[40][72]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][72]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][72]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[43][72]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][72]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][72]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][72]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][72]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][72]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][72]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][72]={10,3,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[51][72]={11,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[52][72]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][72]={0,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[54][72]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][72]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][72]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][72]={0,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][72]={0,-1,5,{{1,5},{0,-1},{1,4}},{9,1},{0,0,0}}
 MapToConvert[59][72]={3,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[60][72]={3,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][72]={3,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[62][72]={3,-1,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[63][72]={3,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[65][72]={3,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][72]={11,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[68][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[73][72]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][72]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][72]={4,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[76][72]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][72]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][72]={3,3,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[79][72]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][72]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][72]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][72]={10,3,5,{{0,-1},{1,0},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[84][72]={10,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[85][72]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][72]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[88][72]={3,-1,5,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[89][72]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][72]={1,-1,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][72]={0,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[92][72]={0,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[93][72]={0,-1,5,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[94][72]={11,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][72]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[96][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[98][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][72]={4,3,5,{{0,-1},{0,-1},{1,4}},{4,1},{0,0,0}}
 MapToConvert[100][72]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][72]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[102][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[103][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][72]={2,-1,2,{{0,-1},{1,3},{1,4}},{-1,1},{1,0,0}}
 MapToConvert[132][72]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][72]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][72]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][72]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[136][72]={3,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[137][72]={3,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[138][72]={3,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[139][72]={3,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][72]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[141][72]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][72]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][72]={3,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][72]={3,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][72]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][72]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][72]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,1}}
 MapToConvert[148][72]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][72]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][72]={9,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[151][72]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][72]={9,3,2,{{1,2},{1,3},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[153][72]={10,3,2,{{1,2},{0,-1},{1,1}},{43,1},{0,0,0}}
 MapToConvert[154][72]={9,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][72]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][72]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][72]={9,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[158][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[159][72]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][72]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,1,1}}
 MapToConvert[162][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][72]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][72]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[166][72]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[167][72]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][72]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][72]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[3][73]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][73]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[5][73]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[6][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][73]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[8][73]={1,-1,17,{{0,-1},{0,-1},{1,4}},{2,1},{0,0,0}}
 MapToConvert[9][73]={1,3,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[10][73]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][73]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[12][73]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[17][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[18][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[22][73]={0,-1,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][73]={0,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[24][73]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[25][73]={0,5,17,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][73]={3,-1,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][73]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[28][73]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][73]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][73]={3,3,17,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[31][73]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][73]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][73]={3,-1,17,{{0,-1},{0,-1},{1,4}},{7,1},{0,0,0}}
 MapToConvert[34][73]={3,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[35][73]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[36][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][73]={0,-1,17,{{0,-1},{1,3},{1,1}},{1,1},{0,0,0}}
 MapToConvert[40][73]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][73]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[45][73]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[47][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][73]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][73]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][73]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][73]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][73]={10,3,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[53][73]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][73]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[55][73]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][73]={0,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][73]={0,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][73]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][73]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][73]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[62][73]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][73]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][73]={3,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[66][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[68][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][73]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[70][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][73]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][73]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][73]={4,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][73]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[75][73]={4,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[76][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][73]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][73]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][73]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][73]={9,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[81][73]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][73]={10,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][73]={4,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][73]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][73]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][73]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][73]={4,3,5,{{0,-1},{1,3},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[90][73]={3,3,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][73]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,0,0}}
 MapToConvert[92][73]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][73]={9,3,5,{{0,-1},{1,0},{1,1}},{31,1},{0,0,0}}
 MapToConvert[94][73]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][73]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[96][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[98][73]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[102][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[104][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[109][73]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][73]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[129][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][73]={0,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[131][73]={0,3,2,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[132][73]={0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][73]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][73]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][73]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][73]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][73]={3,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[138][73]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[139][73]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][73]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][73]={3,3,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[142][73]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][73]={3,3,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][73]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][73]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][73]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][73]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][73]={0,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][73]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][73]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][73]={9,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[153][73]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][73]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[155][73]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][73]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][73]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{14,1},{0,1,1}}
 MapToConvert[158][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[159][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[160][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[164][73]={9,3,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[165][73]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[166][73]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1},{0,1,0}}
 MapToConvert[167][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][73]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][73]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[3][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[4][74]={0,-1,17,{{1,5},{1,3},{1,4}},{2,1},{0,0,0}}
 MapToConvert[5][74]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][74]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[8][74]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][74]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[10][74]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[12][74]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[15][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][74]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[21][74]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[22][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][74]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[29][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[30][74]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][74]={0,5,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[33][74]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][74]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][74]={0,-1,17,{{0,-1},{1,3},{1,4}},{41,1},{0,0,0}}
 MapToConvert[41][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][74]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[49][74]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][74]={9,3,17,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[51][74]={2,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][74]={10,3,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[53][74]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][74]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][74]={0,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][74]={0,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][74]={0,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][74]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][74]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][74]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][74]={0,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[64][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][74]={3,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][74]={3,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[68][74]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[69][74]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][74]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[71][74]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[73][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[75][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][74]={4,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][74]={5,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][74]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[79][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][74]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][74]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[82][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][74]={4,-1,5,{{0,-1},{1,0},{1,1}},{14,1},{0,0,0}}
 MapToConvert[84][74]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][74]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][74]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][74]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][74]={3,3,5,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][74]={3,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][74]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][74]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][74]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][74]={9,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[95][74]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[97][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[99][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[100][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[102][74]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][74]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[107][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[110][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[113][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][74]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,0}}
 MapToConvert[130][74]={1,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[131][74]={0,3,2,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][74]={2,-1,2,{{1,2},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][74]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][74]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[135][74]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][74]={3,3,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[137][74]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][74]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][74]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[141][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[142][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][74]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][74]={4,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][74]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[146][74]={10,3,2,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[147][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][74]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[149][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[153][74]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][74]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][74]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][74]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][74]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[160][74]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[161][74]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[162][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[165][74]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[168][74]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][74]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][75]={0,3,17,{{0,-1},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[5][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[6][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[7][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[11][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[19][75]={0,5,17,{{1,5},{1,3},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[20][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{24,1},{0,0,0}}
 MapToConvert[21][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[23][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[25][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[27][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][75]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][75]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[34][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[36][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[37][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[39][75]={0,3,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][75]={0,3,17,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][75]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][75]={9,3,17,{{0,-1},{0,-1},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[43][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[45][75]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][75]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][75]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][75]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][75]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][75]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][75]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{14,1},{0,0,0}}
 MapToConvert[52][75]={10,3,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[53][75]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][75]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][75]={3,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[56][75]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][75]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[58][75]={3,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][75]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[60][75]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[61][75]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[62][75]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[63][75]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[64][75]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[65][75]={3,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][75]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][75]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][75]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][75]={3,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][75]={3,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][75]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][75]={4,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][75]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[74][75]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][75]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][75]={11,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][75]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[80][75]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][75]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][75]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][75]={10,-1,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][75]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][75]={10,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][75]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][75]={4,-1,5,{{0,-1},{1,3},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[88][75]={3,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[89][75]={3,-1,5,{{1,2},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[90][75]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][75]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][75]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][75]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][75]={3,-1,5,{{0,-1},{0,-1},{1,1}},{9,1},{0,0,0}}
 MapToConvert[95][75]={3,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][75]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[98][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[101][75]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[102][75]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[103][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][75]={1,3,2,{{0,-1},{0,-1},{0,-1}},{43,1},{1,0,0}}
 MapToConvert[130][75]={2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][75]={0,-1,2,{{0,-1},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[132][75]={2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][75]={3,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[134][75]={3,3,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[135][75]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[136][75]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[137][75]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[138][75]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][75]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[140][75]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][75]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[142][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][75]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][75]={9,3,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[145][75]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][75]={9,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[147][75]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][75]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][75]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][75]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[151][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[152][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[153][75]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[154][75]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][75]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][75]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][75]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[158][75]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][75]={10,3,2,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[160][75]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][75]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][75]={10,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[163][75]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[164][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[165][75]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[166][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][75]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][75]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[4][76]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][76]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][76]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][76]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[8][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][76]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][76]={0,-1,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[12][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[19][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][76]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[21][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][76]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[23][76]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[24][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[25][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[26][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,1}}
 MapToConvert[28][76]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][76]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][76]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[31][76]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][76]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][76]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][76]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][76]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{42,1},{0,0,0}}
 MapToConvert[36][76]={3,-1,17,{{0,-1},{1,3},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][76]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[38][76]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[39][76]={0,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[40][76]={9,3,17,{{1,2},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[41][76]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][76]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[43][76]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][76]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][76]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][76]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][76]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[48][76]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][76]={15,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][76]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][76]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][76]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][76]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][76]={9,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[55][76]={3,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][76]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[57][76]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[58][76]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[59][76]={3,3,5,{{1,5},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[60][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][76]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[66][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[67][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][76]={3,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][76]={3,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[72][76]={3,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][76]={3,-1,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][76]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][76]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{26,1},{0,1,0}}
 MapToConvert[76][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[77][76]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[78][76]={10,3,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[79][76]={10,3,5,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[80][76]={3,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[81][76]={3,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[82][76]={3,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[83][76]={4,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[84][76]={4,3,5,{{1,2},{0,-1},{1,1}},{41,1},{0,0,0}}
 MapToConvert[85][76]={4,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[86][76]={3,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[87][76]={3,3,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[88][76]={3,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][76]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][76]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][76]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][76]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[93][76]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[94][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][76]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[102][76]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][76]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[104][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[117][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[125][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[126][76]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][76]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][76]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[129][76]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][76]={3,3,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[131][76]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[132][76]={1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][76]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][76]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[135][76]={9,3,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[136][76]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[137][76]={3,3,2,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[138][76]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[139][76]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[140][76]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[142][76]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[143][76]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][76]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][76]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][76]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[149][76]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[150][76]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[152][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[153][76]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[154][76]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[155][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[157][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][76]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[162][76]={9,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[163][76]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[164][76]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{45,1},{0,1,0}}
 MapToConvert[165][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[166][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][76]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][76]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[4][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][77]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[6][77]={1,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[7][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[8][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[9][77]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{7,1},{1,0,0}}
 MapToConvert[10][77]={1,3,17,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[11][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[12][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[18][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[20][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][77]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][77]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[23][77]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[25][77]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[26][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[29][77]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][77]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][77]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[32][77]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[33][77]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][77]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][77]={15,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[36][77]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][77]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][77]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[39][77]={9,3,17,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[40][77]={9,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[41][77]={9,3,17,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[42][77]={9,3,17,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[43][77]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{2,1},{0,0,0}}
 MapToConvert[44][77]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][77]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][77]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][77]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[48][77]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[49][77]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[50][77]={10,-1,17,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[51][77]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][77]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][77]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][77]={3,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][77]={3,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[56][77]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][77]={9,3,5,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[58][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][77]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[63][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][77]={3,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[69][77]={3,3,5,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[70][77]={3,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[71][77]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[72][77]={3,-1,5,{{1,5},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[73][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[74][77]={3,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][77]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[76][77]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][77]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[78][77]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][77]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][77]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][77]={9,3,5,{{0,-1},{0,-1},{0,-1}},{31,1},{0,0,0}}
 MapToConvert[82][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][77]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][77]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][77]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][77]={10,3,5,{{0,-1},{0,-1},{0,-1}},{8,1},{0,0,0}}
 MapToConvert[87][77]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][77]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][77]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][77]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[91][77]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][77]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[93][77]={0,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[94][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[96][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{3,1},{0,0,0}}
 MapToConvert[98][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][77]={3,3,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[102][77]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][77]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[104][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[106][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][77]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[114][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][77]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,1,1}}
 MapToConvert[117][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[119][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[123][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[124][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[125][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[126][77]={3,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][77]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][77]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][77]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[130][77]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][77]={5,-1,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[132][77]={3,-1,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[133][77]={3,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[134][77]={3,3,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[135][77]={3,3,2,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[136][77]={3,-1,2,{{0,-1},{1,3},{0,-1}},{46,1},{0,0,0}}
 MapToConvert[137][77]={3,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[138][77]={3,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[139][77]={3,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[140][77]={9,-1,2,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[141][77]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{44,1},{0,0,0}}
 MapToConvert[142][77]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[143][77]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[144][77]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[145][77]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[146][77]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[147][77]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[148][77]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[149][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[150][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[151][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{32,1},{0,0,0}}
 MapToConvert[152][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[153][77]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[154][77]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{41,1},{0,0,0}}
 MapToConvert[155][77]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[156][77]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[157][77]={9,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[158][77]={9,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[159][77]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[160][77]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[161][77]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[162][77]={13,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[163][77]={12,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[164][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[165][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[166][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[167][77]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[168][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[169][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[170][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[171][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[172][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[173][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[174][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[175][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[176][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[177][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[178][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[179][77]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[0][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[1][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[2][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[3][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[4][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[5][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[6][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[7][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[8][78]={1,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[9][78]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[10][78]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[11][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[12][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[13][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[14][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[15][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[16][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[17][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[18][78]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[19][78]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[20][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[21][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[22][78]={0,-1,17,{{0,-1},{0,-1},{0,-1}},{1,1},{0,0,0}}
 MapToConvert[23][78]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[24][78]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[25][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,1}}
 MapToConvert[26][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[27][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[28][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[29][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[30][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[31][78]={0,-1,17,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[32][78]={0,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[33][78]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[34][78]={0,5,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[35][78]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[36][78]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[37][78]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[38][78]={9,3,17,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[39][78]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[40][78]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[41][78]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[42][78]={9,3,17,{{0,-1},{1,0},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[43][78]={9,3,17,{{1,5},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[44][78]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[45][78]={9,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[46][78]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[47][78]={9,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[48][78]={3,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[49][78]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[50][78]={3,-1,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[51][78]={10,3,17,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[52][78]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[53][78]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[54][78]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[55][78]={3,3,5,{{0,-1},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[56][78]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[57][78]={9,-1,5,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[58][78]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[59][78]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[60][78]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[61][78]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[62][78]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{7,1},{0,0,0}}
 MapToConvert[63][78]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[64][78]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[65][78]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[66][78]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[67][78]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[68][78]={3,-1,5,{{0,-1},{1,0},{0,-1}},{9,1},{0,0,0}}
 MapToConvert[69][78]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[70][78]={3,3,5,{{1,5},{0,-1},{1,4}},{-1,1},{0,0,0}}
 MapToConvert[71][78]={9,3,5,{{1,5},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[72][78]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[73][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[74][78]={3,-1,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[75][78]={3,3,5,{{1,5},{0,-1},{0,-1}},{16,1},{0,0,0}}
 MapToConvert[76][78]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[77][78]={10,3,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[78][78]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[79][78]={9,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[80][78]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[81][78]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[82][78]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[83][78]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[84][78]={9,3,5,{{0,-1},{1,0},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[85][78]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[86][78]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[87][78]={10,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[88][78]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[89][78]={11,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[90][78]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[91][78]={3,3,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[92][78]={4,3,5,{{0,-1},{0,-1},{0,-1}},{40,1},{0,0,0}}
 MapToConvert[93][78]={11,-1,5,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[94][78]={3,-1,5,{{1,2},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[95][78]={3,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[96][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[97][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[98][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[99][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[100][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[101][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,1}}
 MapToConvert[102][78]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[103][78]={4,-1,5,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[104][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[105][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{5,1},{0,0,0}}
 MapToConvert[106][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[107][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[108][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[109][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[110][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[111][78]={16,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[112][78]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[113][78]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,0}}
 MapToConvert[114][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[115][78]={15,1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[116][78]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{43,1},{0,0,0}}
 MapToConvert[117][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[118][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{45,1},{0,0,0}}
 MapToConvert[119][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[120][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[121][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[122][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[123][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,1,0}}
 MapToConvert[124][78]={10,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{1,0,1}}
 MapToConvert[125][78]={15,-1,-1,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[126][78]={5,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[127][78]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[128][78]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[129][78]={3,3,2,{{0,-1},{0,-1},{0,-1}},{4,1},{0,0,0}}
 MapToConvert[130][78]={4,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[131][78]={5,-1,2,{{1,2},{1,0},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[132][78]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[133][78]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[134][78]={3,3,2,{{0,-1},{0,-1},{0,-1}},{-1,1},{0,0,0}}
 MapToConvert[135][78]={9,3,2,{{0,-1},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[136][78]={9,3,2,{{1,2},{0,-1},{1,1}},{-1,1},{0,0,0}}
 MapToConvert[137][78]={9,3,2,{{1,2},{0